/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth;

import com.google.common.base.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationScheme;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.impl.auth.UsernamePasswordCredential;
import org.uberfire.security.server.HttpSecurityContext;

public class HttpBasicAuthenticationScheme
implements AuthenticationScheme {
    public boolean isAuthenticationRequest(SecurityContext context) {
        HttpSecurityContext httpSecurityContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        return httpSecurityContext.getRequest().getHeader("Authorization") != null;
    }

    public void challengeClient(SecurityContext context) {
    }

    public Credential buildCredential(SecurityContext context) {
        String[] credentials;
        int index;
        HttpSecurityContext httpSecurityContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        String auth = httpSecurityContext.getRequest().getHeader("Authorization");
        if (auth != null && (index = auth.indexOf(32)) > 0 && (credentials = new String(Base64.decodeBase64((String)auth.substring(index)), Charsets.UTF_8).split(":")).length == 2) {
            return new UsernamePasswordCredential(credentials[0], (Object)credentials[1]);
        }
        return null;
    }
}

