/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.security.Resource;
import org.uberfire.security.server.URLResource;
import org.uberfire.security.server.URLResourceManager;

public class URLResourceManagerTest {
    @Test
    public void test() throws InterruptedException, ExecutionException, TimeoutException {
        final URLResourceManager manager = new URLResourceManager(null);
        Assert.assertFalse((boolean)manager.requiresAuthentication((Resource)new URLResource("/a.ico")));
        Assert.assertTrue((boolean)manager.requiresAuthentication((Resource)new URLResource("/a.html")));
        int batchSize = 100;
        final Random rnd = new Random(0L);
        ExecutorService es = Executors.newCachedThreadPool();
        for (int i = 0; i < 100; ++i) {
            int j;
            if (i % 10 == 0) {
                System.out.println("Starting batch #" + i);
            }
            ArrayList<1> requests = new ArrayList<1>(100);
            ArrayList results = new ArrayList(100);
            for (j = 0; j < 100; ++j) {
                final int index = i * 100 + j;
                requests.add(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return manager.requiresAuthentication((Resource)new URLResource("/url" + (index + rnd.nextInt(100)) + "/a.ico"));
                    }
                });
            }
            for (j = 0; j < 100; ++j) {
                results.add(es.submit((Callable)requests.get(j)));
            }
            for (j = 0; j < 100; ++j) {
                Assert.assertFalse((boolean)((Boolean)((Future)results.get(j)).get(1000L, TimeUnit.MILLISECONDS)));
            }
        }
    }
}

