/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.cache;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.guvnor.common.services.backend.cache.Cache;
import org.kie.soup.commons.validation.PortablePreconditions;

public abstract class LRUCache<Path, V>
implements Cache<Path, V> {
    private static final int MAX_ENTRIES = 20;
    private Map<Path, V> cache = Collections.synchronizedMap(this.cache);

    @Override
    public V getEntry(Path path) {
        PortablePreconditions.checkNotNull((String)"path", path);
        return this.cache.get(path);
    }

    @Override
    public void setEntry(Path path, V value) {
        PortablePreconditions.checkNotNull((String)"path", path);
        PortablePreconditions.checkNotNull((String)"value", value);
        this.cache.put(path, value);
    }

    @Override
    public void invalidateCache() {
        this.cache.clear();
    }

    @Override
    public void invalidateCache(Path path) {
        PortablePreconditions.checkNotNull((String)"path", path);
        this.cache.remove(path);
    }

    public Set<Path> getKeys() {
        return this.cache.keySet();
    }
}

