/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.test;

import java.util.ArrayList;
import org.guvnor.common.services.backend.test.TestResultMessageAggregator;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.junit.Assert;
import org.junit.Test;

public class TestResultMessageAggregatorTest {
    @Test
    public void testEmpty() {
        TestResultMessageAggregator testResultMessageAggregator = new TestResultMessageAggregator();
        Assert.assertEquals((long)0L, (long)testResultMessageAggregator.getRunCountSum());
        Assert.assertEquals((long)0L, (long)testResultMessageAggregator.getRuntimeSum());
        Assert.assertEquals((long)0L, (long)testResultMessageAggregator.getFailures().size());
        Assert.assertEquals((long)0L, (long)testResultMessageAggregator.getSummary("test").getRunCount());
        Assert.assertEquals((long)0L, (long)testResultMessageAggregator.getSummary("test").getRunTime());
        Assert.assertEquals((long)0L, (long)testResultMessageAggregator.getSummary("test").getFailures().size());
    }

    @Test
    public void testSum() {
        TestResultMessageAggregator testResultMessageAggregator = new TestResultMessageAggregator();
        testResultMessageAggregator.add(this.getTestResultMessage(1, 1L, new Failure()));
        testResultMessageAggregator.add(this.getTestResultMessage(2, 2L, new Failure(), new Failure()));
        testResultMessageAggregator.add(this.getTestResultMessage(3, 3L, new Failure(), new Failure(), new Failure()));
        Assert.assertEquals((long)6L, (long)testResultMessageAggregator.getRunCountSum());
        Assert.assertEquals((long)6L, (long)testResultMessageAggregator.getRuntimeSum());
        Assert.assertEquals((long)6L, (long)testResultMessageAggregator.getFailures().size());
        Assert.assertEquals((long)6L, (long)testResultMessageAggregator.getSummary("test").getRunCount());
        Assert.assertEquals((long)6L, (long)testResultMessageAggregator.getSummary("test").getRunTime());
        Assert.assertEquals((long)6L, (long)testResultMessageAggregator.getSummary("test").getFailures().size());
    }

    private TestResultMessage getTestResultMessage(int runCount, long runTime, Failure ... failures) {
        ArrayList<Failure> failuresList = new ArrayList<Failure>();
        for (Failure failure : failures) {
            failuresList.add(failure);
        }
        return new TestResultMessage("test", runCount, runTime, failuresList);
    }
}

