/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata.attribute;

import java.util.Map;
import org.guvnor.common.services.backend.metadata.attribute.GeneratedFileAttributes;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractBasicFileAttributeView;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.NeedsPreloadedAttrs;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileTime;

public class GeneratedAttributesView
extends AbstractBasicFileAttributeView<AbstractPath>
implements NeedsPreloadedAttrs {
    public static final String GENERATED_VIEW_NAME = "generated";
    public static final String GENERATED_ATTRIBUTE_NAME = "generated.generated";
    private GeneratedFileAttributes generatedFileAttributes;

    public GeneratedAttributesView(AbstractPath path) {
        super((Path)path);
        final boolean generated = this.extractGenerated();
        final BasicFileAttributes fileAttrs = ((BasicFileAttributeView)path.getFileSystem().provider().getFileAttributeView((Path)path, BasicFileAttributeView.class, new LinkOption[0])).readAttributes();
        this.generatedFileAttributes = new GeneratedFileAttributes(){

            @Override
            public boolean isGenerated() {
                return generated;
            }

            public FileTime lastModifiedTime() {
                return fileAttrs.lastModifiedTime();
            }

            public FileTime lastAccessTime() {
                return fileAttrs.lastAccessTime();
            }

            public FileTime creationTime() {
                return fileAttrs.creationTime();
            }

            public boolean isRegularFile() {
                return fileAttrs.isRegularFile();
            }

            public boolean isDirectory() {
                return fileAttrs.isDirectory();
            }

            public boolean isSymbolicLink() {
                return fileAttrs.isSymbolicLink();
            }

            public boolean isOther() {
                return fileAttrs.isOther();
            }

            public long size() {
                return fileAttrs.size();
            }

            public Object fileKey() {
                return fileAttrs.fileKey();
            }
        };
    }

    private boolean extractGenerated() {
        Map content = ((AbstractPath)this.path).getAttrStorage().getContent();
        Object generatedFileAttribute = content.get(GENERATED_ATTRIBUTE_NAME);
        if (generatedFileAttribute instanceof Boolean) {
            return (Boolean)generatedFileAttribute;
        }
        return false;
    }

    public String name() {
        return GENERATED_VIEW_NAME;
    }

    public Class[] viewTypes() {
        return new Class[]{GeneratedAttributesView.class};
    }

    public GeneratedFileAttributes readAttributes() throws IOException {
        return this.generatedFileAttributes;
    }
}

