/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.archive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.guvnor.common.services.backend.MockIOService;
import org.guvnor.common.services.backend.archive.Archiver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class ArchiverTest {
    private Archiver archiver;
    private MockIOService ioService;

    @Before
    public void setUp() throws Exception {
        final SimpleFileSystemProvider simpleFileSystemProvider = new SimpleFileSystemProvider();
        simpleFileSystemProvider.forceAsDefault();
        this.ioService = (MockIOService)Mockito.spy((Object)new MockIOService(){

            @Override
            public Path get(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
                return simpleFileSystemProvider.getPath(uri);
            }

            @Override
            public InputStream newInputStream(Path path, OpenOption ... openOptions) throws IllegalArgumentException, NoSuchFileException, UnsupportedOperationException, org.uberfire.java.nio.IOException, SecurityException {
                String resourcePath = path.toString().substring(path.toString().indexOf("test-classes") + "test-classes".length());
                if (resourcePath.startsWith("\\")) {
                    resourcePath = resourcePath.replaceAll("\\\\", "/");
                }
                return this.getClass().getResourceAsStream(resourcePath);
            }
        });
        this.archiver = new Archiver((IOService)this.ioService);
    }

    @Test
    public void testZipRepository() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.archiver.archive(outputStream, this.getClass().getResource("testRepository").toURI().toString());
        this.assertZipContains(outputStream, "testRepository/project1/file1.txt", "testRepository/project2/file2.txt");
    }

    @Test
    public void testZipProject() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.archiver.archive(outputStream, this.getClass().getResource("testRepository/project1").toURI().toString());
        this.assertZipContains(outputStream, "project1/file1.txt");
    }

    private void assertZipContains(ByteArrayOutputStream outputStream, String ... fileNames) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
        ZipEntry nextEntry = zipInputStream.getNextEntry();
        HashSet<String> files = new HashSet<String>();
        while (nextEntry != null) {
            files.add(nextEntry.getName());
            nextEntry = zipInputStream.getNextEntry();
        }
        for (String fileName : fileNames) {
            Assert.assertTrue((String)("Zip did not contain " + fileName), (boolean)files.contains(fileName));
        }
    }
}

