/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.file.upload;

import java.io.InputStream;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.guvnor.common.services.backend.file.upload.AbstractFileServlet;
import org.jboss.errai.bus.client.api.QueueSession;
import org.jboss.errai.bus.server.api.SessionProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractFileServletTest {
    @Mock
    private SessionProvider provider;
    @Mock
    private HttpServletRequest request;
    @Mock
    private QueueSession queueSession;
    @Mock
    private HttpSession httpSession;

    @Test
    public void testGetSessionId() throws Exception {
        String clientId = "1";
        String sessionId = "2";
        Mockito.when((Object)this.request.getSession(Mockito.eq((boolean)true))).thenReturn((Object)this.httpSession);
        Mockito.when((Object)this.request.getParameter((String)Mockito.eq((Object)"clientId"))).thenReturn((Object)"1");
        Mockito.when((Object)this.provider.createOrGetSession((Object)this.httpSession, "1")).thenReturn((Object)this.queueSession);
        Mockito.when((Object)this.queueSession.getSessionId()).thenReturn((Object)"2");
        Assert.assertEquals((Object)"2", (Object)this.abstractFileServlet().getSessionId(this.request, this.provider));
    }

    @Test
    public void testGetSessionIdWhenClientIdIsMissing() throws Exception {
        Object clientId = null;
        String sessionId = "InvalidSessionId";
        Mockito.when((Object)this.request.getSession(Mockito.eq((boolean)true))).thenReturn((Object)this.httpSession);
        Mockito.when((Object)this.request.getParameter((String)Mockito.eq((Object)"clientId"))).thenReturn(clientId);
        Mockito.when((Object)this.provider.createOrGetSession((Object)this.httpSession, "0")).thenReturn((Object)this.queueSession);
        Mockito.when((Object)this.queueSession.getSessionId()).thenReturn((Object)"InvalidSessionId");
        Assert.assertEquals((Object)"InvalidSessionId", (Object)this.abstractFileServlet().getSessionId(this.request, this.provider));
    }

    private AbstractFileServlet abstractFileServlet() {
        return new AbstractFileServlet(){

            protected InputStream doLoad(Path path, HttpServletRequest request) {
                return null;
            }

            protected void doCreate(Path path, InputStream data, HttpServletRequest request, String comment) {
            }

            protected void doUpdate(Path path, InputStream data, HttpServletRequest request, String comment) {
            }

            protected Path convertPath(String fileName, String contextPath) throws URISyntaxException {
                return null;
            }

            protected Path convertPath(String fullPath) throws URISyntaxException {
                return null;
            }
        };
    }
}

