/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata.attribute;

import java.util.HashMap;
import org.guvnor.common.services.backend.metadata.attribute.GeneratedAttributesView;
import org.guvnor.common.services.backend.metadata.attribute.GeneratedFileAttributes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.AttrsStorage;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class GeneratedFileAttributesViewTest {
    @Test
    public void readAttributesGeneratedFile() {
        this.readAttributesTest(true);
    }

    @Test
    public void readAttributesNonGeneratedFile() {
        this.readAttributesTest(false);
    }

    private void readAttributesTest(final boolean generated) {
        AttrsStorage attrsStorage = (AttrsStorage)Mockito.mock(AttrsStorage.class);
        Mockito.when((Object)attrsStorage.getContent()).thenReturn((Object)new HashMap<String, Object>(){
            {
                this.put("generated.generated", generated);
            }
        });
        AbstractPath path = (AbstractPath)Mockito.mock(AbstractPath.class);
        Mockito.when((Object)path.getAttrStorage()).thenReturn((Object)attrsStorage);
        FileSystemProvider fileSystemProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        BasicFileAttributeView basicFileAttributeView = (BasicFileAttributeView)Mockito.mock(BasicFileAttributeView.class);
        Mockito.when((Object)basicFileAttributeView.readAttributes()).thenReturn(Mockito.mock(BasicFileAttributes.class));
        Mockito.when((Object)fileSystemProvider.getFileAttributeView((Path)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(), new LinkOption[0])).thenReturn((Object)basicFileAttributeView);
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fileSystem.provider()).thenReturn((Object)fileSystemProvider);
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)fileSystem);
        GeneratedAttributesView view = new GeneratedAttributesView(path);
        GeneratedFileAttributes generatedFileAttributes = view.readAttributes();
        Assert.assertEquals((Object)generated, (Object)generatedFileAttributes.isGenerated());
    }
}

