/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.server.adapter.GroupsAdapter;

@ApplicationScoped
public class JettyGroupsAdapter
implements GroupsAdapter {
    private static final String GROUPS_DEFINITION_FILE = "/jetty-groups.properties";
    private static final Logger logger = LoggerFactory.getLogger(JettyGroupsAdapter.class);
    private Map<String, List<Group>> groupsByUser = null;

    public JettyGroupsAdapter() {
        InputStream input = this.getClass().getResourceAsStream(GROUPS_DEFINITION_FILE);
        if (input != null) {
            try {
                Properties properties = new Properties();
                properties.load(input);
                this.groupsByUser = new HashMap<String, List<Group>>();
                Set<String> userNames = properties.stringPropertyNames();
                for (String userName : userNames) {
                    String groupsStr = properties.getProperty(userName);
                    ArrayList<GroupImpl> userGroups = new ArrayList<GroupImpl>();
                    if (groupsStr != null) {
                        String[] groups;
                        for (String group : groups = groupsStr.split(",")) {
                            userGroups.add(new GroupImpl(group));
                        }
                    }
                    this.groupsByUser.put(userName, userGroups);
                }
            }
            catch (IOException e) {
                logger.warn("Unable to load jetty-groups.properties file due to {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<Group> getGroups(String principalName) {
        if (this.groupsByUser == null || !this.groupsByUser.containsKey(principalName)) {
            return Collections.emptyList();
        }
        return this.groupsByUser.get(principalName);
    }
}

