/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.PathMatcher;
import org.uberfire.java.nio.file.PatternSyntaxException;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.file.attribute.UserPrincipalLookupService;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

public class IOSecurityService
implements IOService {
    private final IOService service;
    private final AuthenticationService authenticationService;
    private final AuthorizationManager authManager;

    public IOSecurityService(IOService service, AuthenticationService authenticationService, AuthorizationManager authManager) {
        this.authManager = (AuthorizationManager)PortablePreconditions.checkNotNull((String)"authManager", (Object)authManager);
        this.service = (IOService)PortablePreconditions.checkNotNull((String)"service", (Object)service);
        this.authenticationService = (AuthenticationService)PortablePreconditions.checkNotNull((String)"provider", (Object)authenticationService);
        PortablePreconditions.checkCondition((String)"auth manager doesn't support file system", (boolean)authManager.supports((Resource)new FileSystemResourceAdaptor(null)));
    }

    public void dispose() {
        this.service.dispose();
    }

    public void startBatch(FileSystem fs) throws InterruptedException {
        if (!this.authManager.authorize(this.toResource(fs), this.getUser())) {
            throw new SecurityException();
        }
        this.service.startBatch(fs);
    }

    public void startBatch(FileSystem[] fss, Option ... options) throws InterruptedException {
        for (FileSystem fs : fss) {
            if (this.authManager.authorize(this.toResource(fs), this.getUser())) continue;
            throw new SecurityException();
        }
        this.service.startBatch(fss, options);
    }

    public void startBatch(FileSystem fs, Option ... options) throws InterruptedException {
        if (!this.authManager.authorize(this.toResource(fs), this.getUser())) {
            throw new SecurityException();
        }
        this.service.startBatch(fs, options);
    }

    public void startBatch(FileSystem ... fss) throws InterruptedException {
        for (FileSystem fs : fss) {
            if (this.authManager.authorize(this.toResource(fs), this.getUser())) continue;
            throw new SecurityException();
        }
        this.service.startBatch(fss);
    }

    public void endBatch() {
        this.service.endBatch();
    }

    public FileAttribute<?>[] convert(Map<String, ?> attrs) {
        return this.service.convert(attrs);
    }

    public Path get(String first, String ... more) throws IllegalArgumentException {
        Path result = this.service.get(first, more);
        if (!this.authManager.authorize(this.toResource(result), this.getUser())) {
            throw new SecurityException();
        }
        return result;
    }

    public Path get(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        try {
            Path result = this.service.get(uri);
            if (!this.authManager.authorize(this.toResource(result), this.getUser())) {
                throw new SecurityException();
            }
            return result;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemNotFoundException ex) {
            throw ex;
        }
    }

    public Iterable<FileSystem> getFileSystems() {
        Iterable _result = this.service.getFileSystems();
        HashSet<FileSystem> result = new HashSet<FileSystem>();
        for (FileSystem fs : _result) {
            if (!this.authManager.authorize(this.toResource(fs), this.getUser())) continue;
            result.add(fs);
        }
        return result;
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException {
        try {
            FileSystem result = this.service.getFileSystem(uri);
            if (!this.authManager.authorize(this.toResource(result), this.getUser())) {
                throw new SecurityException();
            }
            return result;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemNotFoundException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        try {
            FileSystem fs = this.service.newFileSystem(uri, env);
            if (!this.authManager.authorize(this.toResource(fs), this.getUser())) {
                this.service.delete(fs.getPath(null, new String[0]), new DeleteOption[0]);
                throw new SecurityException();
            }
            return fs;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemNotFoundException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
    }

    public void onNewFileSystem(IOService.NewFileSystemListener listener) {
        this.service.onNewFileSystem(listener);
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.newInputStream(path, options);
    }

    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.newOutputStream(path, options);
    }

    public SeekableByteChannel newByteChannel(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.newByteChannel(path, options);
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.newByteChannel(path, options, attrs);
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(dir), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.newDirectoryStream(dir);
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<Path> filter) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(dir), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.newDirectoryStream(dir, filter);
    }

    public Path createFile(Path path, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.createFile(path, attrs);
    }

    public Path createDirectory(Path dir, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(dir), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.createFile(dir, attrs);
    }

    public Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(dir), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.createDirectories(dir, attrs);
    }

    public Path createDirectory(Path dir, Map<String, ?> attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(dir), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.createDirectory(dir, attrs);
    }

    public Path createDirectories(Path dir, Map<String, ?> attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(dir), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.createDirectories(dir, attrs);
    }

    public void delete(Path path, DeleteOption ... options) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        this.service.delete(path, options);
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.deleteIfExists(path, options);
    }

    public Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.service.createTempFile(prefix, suffix, attrs);
    }

    public Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(dir), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.createTempFile(dir, prefix, suffix, attrs);
    }

    public Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.service.createTempDirectory(prefix, attrs);
    }

    public Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(dir), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.createTempDirectory(dir, prefix, attrs);
    }

    public Path copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(source), this.getUser())) {
            throw new SecurityException();
        }
        if (!this.authManager.authorize(this.toResource(target), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.copy(source, target, options);
    }

    public Path move(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(source), this.getUser())) {
            throw new SecurityException();
        }
        if (!this.authManager.authorize(this.toResource(target), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.move(source, target, options);
    }

    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type) throws IllegalArgumentException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return (V)this.service.getFileAttributeView(path, type);
    }

    public Map<String, Object> readAttributes(Path path) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.readAttributes(path);
    }

    public Map<String, Object> readAttributes(Path path, String attributes) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.readAttributes(path, attributes);
    }

    public Path setAttributes(Path path, FileAttribute<?> ... attrs) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.setAttributes(path, attrs);
    }

    public Path setAttributes(Path path, Map<String, Object> attrs) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.setAttributes(path, attrs);
    }

    public Path setAttribute(Path path, String attribute, Object value) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.setAttribute(path, attribute, value);
    }

    public Object getAttribute(Path path, String attribute) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.getAttribute(path, attribute);
    }

    public FileTime getLastModifiedTime(Path path) throws IllegalArgumentException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.getLastModifiedTime(path);
    }

    public long size(Path path) throws IllegalArgumentException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.size(path);
    }

    public boolean exists(Path path) throws IllegalArgumentException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.exists(path);
    }

    public boolean notExists(Path path) throws IllegalArgumentException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.notExists(path);
    }

    public boolean isSameFile(Path path, Path path2) throws IllegalArgumentException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        if (!this.authManager.authorize(this.toResource(path2), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.isSameFile(path, path2);
    }

    public BufferedReader newBufferedReader(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.newBufferedReader(path, cs);
    }

    public BufferedWriter newBufferedWriter(Path path, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.newBufferedWriter(path, cs, options);
    }

    public long copy(InputStream in, Path target, CopyOption ... options) throws IOException, FileAlreadyExistsException, DirectoryNotEmptyException, UnsupportedOperationException, SecurityException {
        if (!this.authManager.authorize(this.toResource(target), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.copy(in, target, options);
    }

    public long copy(Path source, OutputStream out) throws IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(source), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.copy(source, out);
    }

    public byte[] readAllBytes(Path path) throws IOException, OutOfMemoryError, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.readAllBytes(path);
    }

    public List<String> readAllLines(Path path) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.readAllLines(path);
    }

    public List<String> readAllLines(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.readAllLines(path, cs);
    }

    public String readAllString(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.readAllString(path, cs);
    }

    public String readAllString(Path path) throws IllegalArgumentException, NoSuchFileException, IOException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.readAllString(path);
    }

    public Path write(Path path, byte[] bytes, OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, bytes, new OpenOption[0]);
    }

    public Path write(Path path, byte[] bytes, Map<String, ?> attrs, OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, bytes, attrs, options);
    }

    public Path write(Path path, byte[] bytes, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, bytes, options, attrs);
    }

    public Path write(Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, lines, cs, options);
    }

    public Path write(Path path, String content, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, content, options);
    }

    public Path write(Path path, String content, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, content, cs, options);
    }

    public Path write(Path path, String content, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, content, options, attrs);
    }

    public Path write(Path path, String content, Charset cs, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, content, cs, options, attrs);
    }

    public Path write(Path path, String content, Map<String, ?> attrs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, content, attrs, options);
    }

    public Path write(Path path, String content, Charset cs, Map<String, ?> attrs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (!this.authManager.authorize(this.toResource(path), this.getUser())) {
            throw new SecurityException();
        }
        return this.service.write(path, content, cs, attrs, options);
    }

    private Resource toResource(FileSystem fs) {
        return new FileSystemResourceAdaptor(fs);
    }

    private Resource toResource(Path path) {
        return new FileSystemResourceAdaptor(path.getFileSystem());
    }

    private User getUser() {
        try {
            return this.authenticationService.getUser();
        }
        catch (IllegalStateException ex) {
            return new UserImpl("system", Arrays.asList(new RoleImpl("admin")));
        }
    }

    private static class DummyFileSystem
    implements FileSystem,
    Resource {
        private DummyFileSystem() {
        }

        public FileSystemProvider provider() {
            return null;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public String getSeparator() {
            return null;
        }

        public Iterable<Path> getRootDirectories() {
            return null;
        }

        public Iterable<FileStore> getFileStores() {
            return null;
        }

        public Set<String> supportedFileAttributeViews() {
            return null;
        }

        public Path getPath(String first, String ... more) throws InvalidPathException {
            return null;
        }

        public PathMatcher getPathMatcher(String syntaxAndPattern) throws IllegalArgumentException, PatternSyntaxException, UnsupportedOperationException {
            return null;
        }

        public UserPrincipalLookupService getUserPrincipalLookupService() throws UnsupportedOperationException {
            return null;
        }

        public WatchService newWatchService() throws UnsupportedOperationException, IOException {
            return null;
        }

        public void close() throws IOException {
        }

        public void dispose() {
        }
    }
}

