/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import com.google.common.base.Charsets;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;

public class BasicAuthSecurityFilter
implements Filter {
    public static final String REALM_NAME_PARAM = "realmName";
    @Inject
    private AuthenticationService authenticationService;
    private String realmName = "UberFire Security Extension Default Realm";

    public void init(FilterConfig filterConfig) throws ServletException {
        String realmName = filterConfig.getInitParameter(REALM_NAME_PARAM);
        if (realmName != null) {
            this.realmName = realmName;
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest _request, ServletResponse _response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)_request;
        HttpServletResponse response = (HttpServletResponse)_response;
        User user = this.authenticationService.getUser();
        try {
            if (user == null) {
                if (this.authenticate(request)) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    if (response.isCommitted()) {
                        this.authenticationService.logout();
                    }
                } else {
                    this.challengeClient(request, response);
                }
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }
    }

    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        if (this.isAjaxRequest(request)) {
            response.sendError(403);
        } else {
            response.sendError(401);
        }
    }

    private boolean authenticate(HttpServletRequest req) {
        String authHead = req.getHeader("Authorization");
        if (authHead != null) {
            int index = authHead.indexOf(32);
            String[] credentials = new String(Base64.decodeBase64((String)authHead.substring(index)), Charsets.UTF_8).split(":");
            try {
                this.authenticationService.login(credentials[0], credentials[1]);
                return true;
            }
            catch (FailedAuthenticationException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        return request.getHeader("X-Requested-With") != null && "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }
}

