/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server.io;

import java.util.Arrays;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.ext.security.server.io.IOSecurityService;
import org.uberfire.ext.security.server.io.MockAuthenticationService;
import org.uberfire.ext.security.server.io.MockIOService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

public class IOServiceSecuritySetupTest {
    @Test
    public void nonSecureExecuted() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)fs.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)fs);
        IOSecurityService service = new IOSecurityService((IOService)new MockIOService(), (AuthenticationService)new MockAuthenticationService(), new AuthorizationManager(){

            public boolean supports(Resource resource) {
                return resource instanceof FileSystemResourceAdaptor;
            }

            public boolean authorize(Resource resource, User user) throws UnauthorizedException {
                return true;
            }
        });
        Assert.assertTrue((boolean)PriorityDisposableRegistry.getDisposables().contains(service));
        try {
            service.startBatch(fs);
        }
        catch (Exception e) {
            Assert.fail((String)"error");
        }
    }

    @Test
    public void secureExecuted() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)fs.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)fs);
        IOSecurityService service = new IOSecurityService((IOService)new MockIOService(), (AuthenticationService)new MockAuthenticationService(), new AuthorizationManager(){

            public boolean supports(Resource resource) {
                return resource instanceof FileSystemResourceAdaptor;
            }

            public boolean authorize(Resource resource, User user) throws UnauthorizedException {
                return false;
            }
        });
        try {
            service.startBatch(fs);
            Assert.fail((String)"error");
        }
        catch (SecurityException securityException) {
        }
        catch (Exception e) {
            Assert.fail((String)"error");
        }
    }
}

