/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.uberfire.backend.server.security.RoleRegistry;

public class SecurityIntegrationFilter
implements Filter {
    public static final String PROBE_ROLES_INIT_PARAM = "probe-for-roles";
    static final ThreadLocal<HttpServletRequest> requests = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
        MappingContextSingleton.get();
        String commaSeparatedRoles = filterConfig.getInitParameter(PROBE_ROLES_INIT_PARAM);
        if (commaSeparatedRoles != null) {
            for (String role : Collections.unmodifiableList(Arrays.asList(commaSeparatedRoles.split(",")))) {
                RoleRegistry.get().registerRole(role);
            }
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        requests.set((HttpServletRequest)request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            requests.remove();
        }
    }

    public static HttpServletRequest getRequest() {
        return requests.get();
    }
}

