/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.server.BasicAuthSecurityFilter;

@RunWith(value=MockitoJUnitRunner.class)
public class BasicAuthSecurityFilterTest {
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private FilterChain chain;
    @Mock
    private AuthenticationService authenticationService;
    @Mock
    private HttpSession httpSession;

    @Test
    public void testIndependentSessionInvalidated() throws Exception {
        SessionProvider sessionProvider = new SessionProvider(this.httpSession, 1);
        Mockito.when((Object)this.authenticationService.getUser()).thenReturn((Object)new UserImpl("testUser"));
        Mockito.when((Object)this.request.getSession(Mockito.anyBoolean())).then(invocationOnMock -> sessionProvider.provideSession());
        BasicAuthSecurityFilter filter = new BasicAuthSecurityFilter();
        filter.authenticationService = this.authenticationService;
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((HttpSession)Mockito.verify((Object)this.httpSession, (VerificationMode)Mockito.times((int)1))).invalidate();
    }

    @Test
    public void testExistingSessionNotInvalidated() throws Exception {
        SessionProvider sessionProvider = new SessionProvider(this.httpSession);
        Mockito.when((Object)this.authenticationService.getUser()).thenReturn((Object)new UserImpl("testUser"));
        Mockito.when((Object)this.request.getSession(Mockito.anyBoolean())).then(invocationOnMock -> sessionProvider.provideSession());
        BasicAuthSecurityFilter filter = new BasicAuthSecurityFilter();
        filter.authenticationService = this.authenticationService;
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((HttpSession)Mockito.verify((Object)this.httpSession, (VerificationMode)Mockito.never())).invalidate();
    }

    @Test
    public void testNotInvalidateSession() throws Exception {
        SessionProvider sessionProvider = new SessionProvider(this.httpSession, 1);
        Mockito.when((Object)this.authenticationService.getUser()).thenReturn((Object)new UserImpl("testUser"));
        Mockito.when((Object)this.request.getSession(Mockito.anyBoolean())).then(invocationOnMock -> sessionProvider.provideSession());
        BasicAuthSecurityFilter filter = new BasicAuthSecurityFilter();
        FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("invalidate")).thenReturn((Object)"false");
        filter.init(config);
        filter.authenticationService = this.authenticationService;
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((HttpSession)Mockito.verify((Object)this.httpSession, (VerificationMode)Mockito.never())).invalidate();
    }

    @Test
    public void testEmptyPassword() throws Exception {
        String username = "fakeUser";
        String password = "";
        String authData = username + ":" + password;
        String authEncoded = Base64.encodeBase64String((byte[])authData.getBytes());
        Mockito.when((Object)this.request.getHeader("Authorization")).thenReturn((Object)("Basic " + authEncoded));
        BasicAuthSecurityFilter filter = new BasicAuthSecurityFilter();
        filter.authenticationService = this.authenticationService;
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((AuthenticationService)Mockito.verify((Object)this.authenticationService, (VerificationMode)Mockito.times((int)1))).login(username, password);
    }

    private class SessionProvider {
        private int counter = 0;
        private HttpSession httpSession;

        public SessionProvider(HttpSession httpSession) {
            this.httpSession = httpSession;
        }

        public SessionProvider(HttpSession httpSession, int counter) {
            this.httpSession = httpSession;
            this.counter = counter;
        }

        public HttpSession provideSession() {
            if (this.counter == 0) {
                return this.httpSession;
            }
            --this.counter;
            return null;
        }
    }
}

