/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import javax.enterprise.inject.Instance;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.server.CleanupSecurityCacheSessionListener;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class CleanupSecurityCacheSessionListenerTest {
    @Mock
    private HttpSessionEvent evt;
    @Mock
    private HttpSession session;

    @Test
    public void testSessionCleanup() {
        AuthorizationManager authorizationManager1 = (AuthorizationManager)Mockito.mock(AuthorizationManager.class);
        AuthorizationManager authorizationManager2 = (AuthorizationManager)Mockito.mock(AuthorizationManager.class);
        Instance instances = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)instances.iterator()).thenReturn(Arrays.asList(authorizationManager1, authorizationManager2).iterator());
        CleanupSecurityCacheSessionListener listener = new CleanupSecurityCacheSessionListener(instances);
        UserImpl user = new UserImpl("user", (Collection)ImmutableSet.of((Object)new RoleImpl("author")));
        Mockito.when((Object)this.evt.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getAttribute("uf.security.user")).thenReturn((Object)user);
        listener.sessionDestroyed(this.evt);
        ((AuthorizationManager)Mockito.verify((Object)authorizationManager1, (VerificationMode)Mockito.times((int)1))).invalidate((User)user);
        ((AuthorizationManager)Mockito.verify((Object)authorizationManager2, (VerificationMode)Mockito.times((int)1))).invalidate((User)user);
    }

    @Test
    public void testSessionCleanupNPE() {
        CleanupSecurityCacheSessionListener listener = new CleanupSecurityCacheSessionListener();
        UserImpl user = new UserImpl("user", (Collection)ImmutableSet.of((Object)new RoleImpl("author")));
        Mockito.when((Object)this.evt.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getAttribute("uf.security.user")).thenReturn((Object)user);
        listener.sessionDestroyed(this.evt);
    }
}

