/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.ext.security.server.SecurityIntegrationFilter;
import org.uberfire.ext.security.server.ServletSecurityAuthenticationService;

@RunWith(value=MockitoJUnitRunner.class)
public class ServletSecurityAuthenticationServiceTest {
    private static final String USERNAME = "user1";
    private static final String PASSWORD = "password1";
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpSession httpSession;
    private ServletSecurityAuthenticationService tested;

    @Before
    public void setup() throws Exception {
        Principal p1 = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)p1.getName()).thenReturn((Object)USERNAME);
        ((HttpServletRequest)Mockito.doReturn((Object)p1).when((Object)this.request)).getUserPrincipal();
        ((HttpServletRequest)Mockito.doReturn((Object)this.httpSession).when((Object)this.request)).getSession();
        ((HttpSession)Mockito.doReturn(null).when((Object)this.httpSession)).getAttribute((String)Matchers.eq((Object)"uf.security.user"));
        Mockito.when((Object)this.request.getSession(Matchers.anyBoolean())).then((Answer)new Answer<HttpSession>(){

            public HttpSession answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ServletSecurityAuthenticationServiceTest.this.httpSession;
            }
        });
        this.tested = (ServletSecurityAuthenticationService)Mockito.spy((Object)new ServletSecurityAuthenticationService());
        SecurityIntegrationFilter.requests.set(this.request);
    }

    @Test
    public void testLoggedIn() {
        Assert.assertTrue((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testNotLoggedIn() {
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)this.request)).getUserPrincipal();
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testLogin() throws Exception {
        RoleRegistry.get().registerRole("admin");
        RoleRegistry.get().registerRole("role1");
        Set<Principal> principals = this.mockPrincipals("admin", "role1", "group1", null);
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        ((ServletSecurityAuthenticationService)Mockito.doReturn((Object)subject).when((Object)this.tested)).getSubjectFromPolicyContext();
        User user = this.tested.login(USERNAME, PASSWORD);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)USERNAME, (Object)user.getIdentifier());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)1L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("group1")));
    }

    @Test
    public void testLoginNoPrincipal() throws Exception {
        Subject subject = new Subject();
        ((ServletSecurityAuthenticationService)Mockito.doReturn((Object)subject).when((Object)this.tested)).getSubjectFromPolicyContext();
        User user = this.tested.login(USERNAME, PASSWORD);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)USERNAME, (Object)user.getIdentifier());
        Assert.assertEquals((long)0L, (long)user.getRoles().size());
        Assert.assertEquals((long)0L, (long)user.getGroups().size());
    }

    @Test
    public void testLoginSubjectGroups() throws Exception {
        String username = USERNAME;
        String password = PASSWORD;
        RoleRegistry.get().registerRole("admin");
        RoleRegistry.get().registerRole("role1");
        Set<Principal> principals = this.mockPrincipals("admin", "role1", "group1");
        Group aclGroup = (Group)Mockito.mock(Group.class);
        ((Group)Mockito.doReturn((Object)"Roles").when((Object)aclGroup)).getName();
        Set<Principal> aclGroups = this.mockPrincipals("g1", "g2");
        Enumeration<Principal> aclGroupsEnum = Collections.enumeration(aclGroups);
        ((Group)Mockito.doReturn(aclGroupsEnum).when((Object)aclGroup)).members();
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        subject.getPrincipals().add((Principal)aclGroup);
        ((ServletSecurityAuthenticationService)Mockito.doReturn((Object)subject).when((Object)this.tested)).getSubjectFromPolicyContext();
        User user = this.tested.login(username, password);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)username, (Object)user.getIdentifier());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)3L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("group1")));
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("g1")));
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("g2")));
    }

    @Test
    public void testLoginWithUsernameInPrincipal() throws Exception {
        RoleRegistry.get().registerRole("admin");
        RoleRegistry.get().registerRole("role1");
        Set<Principal> principals = this.mockPrincipals("admin", "role1", "group1", USERNAME, null);
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        ((ServletSecurityAuthenticationService)Mockito.doReturn((Object)subject).when((Object)this.tested)).getSubjectFromPolicyContext();
        User user = this.tested.login(USERNAME, PASSWORD);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)USERNAME, (Object)user.getIdentifier());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)1L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("group1")));
        Assert.assertFalse((boolean)user.getGroups().contains(new GroupImpl(USERNAME)));
    }

    @Test
    public void testLogout() throws Exception {
        this.tested.logout();
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).logout();
        ((HttpSession)Mockito.verify((Object)this.httpSession, (VerificationMode)Mockito.times((int)1))).invalidate();
    }

    @Test
    public void testSwallowIllegalStateExceptionDuringLogoutWithKeycloak() {
        ((HttpSession)Mockito.doThrow((Throwable)new IllegalStateException("UT000021: Session already invalidated")).when((Object)this.httpSession)).invalidate();
        this.tested.logout();
    }

    @Test
    public void testReThrowUnexpectedIllegalStateExceptionDuringLogout() {
        String exceptionMsg = "This exception should be propagated!";
        ((HttpSession)Mockito.doThrow((Throwable)new IllegalStateException(exceptionMsg)).when((Object)this.httpSession)).invalidate();
        try {
            this.tested.logout();
        }
        catch (IllegalStateException ise) {
            Assert.assertEquals((Object)exceptionMsg, (Object)ise.getMessage());
        }
    }

    private Set<Principal> mockPrincipals(String ... names) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String name : names) {
            Principal p1 = (Principal)Mockito.mock(Principal.class);
            Mockito.when((Object)p1.getName()).thenReturn((Object)name);
            principals.add(p1);
        }
        return principals;
    }
}

