/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.util.Calendar;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.security.server.CacheHeadersFilter;

@RunWith(value=MockitoJUnitRunner.class)
public class CacheHeadersFilterTest {
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private FilterChain chain;

    @Test
    public void cacheFilesWithCacheExtension() throws Exception {
        Mockito.when((Object)this.request.getRequestURI()).thenReturn((Object)"/app/hash.cache.js");
        CacheHeadersFilter filter = new CacheHeadersFilter();
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Cache-Control", "max-age=31536000, must-revalidate");
        ArgumentCaptor expiresHeader = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor expiresValue = ArgumentCaptor.forClass(Long.class);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setDateHeader((String)expiresHeader.capture(), ((Long)expiresValue.capture()).longValue());
        Assert.assertEquals((Object)"Expires", (Object)expiresHeader.getValue());
        Calendar expiryDate = Calendar.getInstance();
        expiryDate.setTimeInMillis((Long)expiresValue.getValue());
        Calendar now = Calendar.getInstance();
        long expiryInDays = (expiryDate.getTimeInMillis() - now.getTimeInMillis()) / 86400000L;
        Assert.assertTrue((expiryInDays >= 364L ? 1 : 0) != 0);
    }

    @Test
    public void doNotCacheFilesWithNoCacheExtension() throws Exception {
        Mockito.when((Object)this.request.getRequestURI()).thenReturn((Object)"/app/abc.nocache.js");
        this.verifyNoCache();
    }

    @Test
    public void doNotCacheHostPage() throws Exception {
        Mockito.when((Object)this.request.getRequestURI()).thenReturn((Object)"/host-page.html");
        this.verifyNoCache();
    }

    private void verifyNoCache() throws Exception {
        CacheHeadersFilter filter = new CacheHeadersFilter();
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setDateHeader("Expires", 0L);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Pragma", "no-cache");
    }
}

