/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server.io;

import java.net.URI;
import java.util.Arrays;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.ext.security.server.io.IOSecurityService;
import org.uberfire.ext.security.server.io.MockAuthenticationService;
import org.uberfire.ext.security.server.io.MockIOService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCheck;
import org.uberfire.security.authz.ResourceCheck;
import org.uberfire.security.authz.VotingStrategy;

public class IOServiceSecuritySetupTest {
    @Test
    public void nonSecureExecuted() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)fs.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)fs);
        Mockito.when((Object)rootPath.toUri()).thenReturn((Object)URI.create("/"));
        IOSecurityService service = new IOSecurityService((IOService)new MockIOService(), (AuthenticationService)new MockAuthenticationService(), (AuthorizationManager)new DummyAuthorizationManager(true));
        Assert.assertTrue((boolean)PriorityDisposableRegistry.getDisposables().contains(service));
        try {
            service.startBatch(fs);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"error");
        }
    }

    @Test
    public void secureExecuted() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)rootPath.toUri()).thenReturn((Object)URI.create("/"));
        Mockito.when((Object)fs.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)fs);
        IOSecurityService service = new IOSecurityService((IOService)new MockIOService(), (AuthenticationService)new MockAuthenticationService(), (AuthorizationManager)new DummyAuthorizationManager(false));
        try {
            service.startBatch(fs);
            Assert.fail((String)"error");
        }
        catch (SecurityException securityException) {
        }
        catch (Exception e) {
            Assert.fail((String)"error");
        }
    }

    class DummyAuthorizationManager
    implements AuthorizationManager {
        private boolean grant;

        public DummyAuthorizationManager(boolean grant) {
            this.grant = grant;
        }

        public boolean authorize(Resource resource, User user, VotingStrategy votingStrategy) {
            return this.grant;
        }

        public boolean authorize(Resource resource, ResourceAction action, User user, VotingStrategy votingStrategy) {
            return this.grant;
        }

        public boolean authorize(ResourceType resourceType, ResourceAction action, User user, VotingStrategy votingStrategy) {
            return this.grant;
        }

        public boolean authorize(String permission, User user, VotingStrategy votingStrategy) {
            return this.grant;
        }

        public boolean authorize(Permission permission, User user, VotingStrategy votingStrategy) {
            return this.grant;
        }

        public ResourceCheck check(Resource resource, User user, VotingStrategy votingStrategy) {
            return null;
        }

        public ResourceCheck check(ResourceType resourceType, User user, VotingStrategy votingStrategy) {
            return null;
        }

        public PermissionCheck check(String permission, User user, VotingStrategy votingStrategy) {
            return null;
        }

        public boolean authorize(Resource resource, User user) {
            return this.grant;
        }

        public boolean authorize(Resource resource, ResourceAction action, User user) {
            return this.grant;
        }

        public boolean authorize(ResourceType resourceType, ResourceAction action, User user) {
            return this.grant;
        }

        public boolean authorize(String permission, User user) {
            return this.grant;
        }

        public boolean authorize(Permission permission, User user) {
            return this.grant;
        }

        public ResourceCheck check(Resource resource, User user) {
            return null;
        }

        public ResourceCheck check(ResourceType type, User user) {
            return null;
        }

        public PermissionCheck check(String permission, User user) {
            return null;
        }

        public void invalidate(User user) {
        }
    }
}

