/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.security.Principal;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.ext.security.server.SecurityIntegrationFilter;
import org.uberfire.ext.security.server.ServletSecurityAuthenticationService;

@RunWith(value=MockitoJUnitRunner.class)
public class ServletSecurityAuthenticationServiceTest {
    private static final String USERNAME = "user1";
    private static final String PASSWORD = "password1";
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpSession httpSession;
    private ServletSecurityAuthenticationService tested;

    @Before
    public void setup() throws Exception {
        Principal p1 = (Principal)Mockito.mock(Principal.class);
        ((Principal)Mockito.doReturn((Object)USERNAME).when((Object)p1)).getName();
        ((HttpServletRequest)Mockito.doReturn((Object)p1).when((Object)this.request)).getUserPrincipal();
        ((HttpServletRequest)Mockito.doReturn((Object)this.httpSession).when((Object)this.request)).getSession();
        ((HttpSession)Mockito.doReturn(null).when((Object)this.httpSession)).getAttribute((String)ArgumentMatchers.eq((Object)"uf.security.user"));
        Mockito.when((Object)this.request.getSession(ArgumentMatchers.anyBoolean())).then((Answer)new Answer<HttpSession>(){

            public HttpSession answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ServletSecurityAuthenticationServiceTest.this.httpSession;
            }
        });
        this.tested = (ServletSecurityAuthenticationService)Mockito.spy((Object)new ServletSecurityAuthenticationService());
        SecurityIntegrationFilter.requests.set(this.request);
    }

    @Test
    public void testLoggedIn() {
        Assert.assertTrue((boolean)this.tested.isLoggedIn());
    }

    @Test
    public void testNotLoggedIn() {
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)this.request)).getUserPrincipal();
        Assert.assertFalse((boolean)this.tested.isLoggedIn());
    }

    @Test(expected=FailedAuthenticationException.class)
    public void testLoginFailure() throws ServletException {
        ((HttpServletRequest)Mockito.doThrow((Throwable[])new Throwable[]{new ServletException()}).when((Object)this.request)).login("test", "test");
        this.tested.login("test", "test");
    }

    @Test
    public void testLogin() throws Exception {
        RoleRegistry.get().registerRole("admin");
        RoleRegistry.get().registerRole("role1");
        ArrayList<String> principals = new ArrayList<String>();
        principals.add("admin");
        principals.add("role1");
        principals.add("group1");
        ((ServletSecurityAuthenticationService)Mockito.doReturn(principals).when((Object)this.tested)).getPrincipals();
        User user = this.tested.login(USERNAME, PASSWORD);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)USERNAME, (Object)user.getIdentifier());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("admin")));
        Assert.assertTrue((boolean)user.getRoles().contains(new RoleImpl("role1")));
        Assert.assertEquals((long)1L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().contains(new GroupImpl("group1")));
    }

    @Test
    public void testLoginNoPrincipal() throws Exception {
        ((ServletSecurityAuthenticationService)Mockito.doReturn(new ArrayList()).when((Object)this.tested)).getPrincipals();
        User user = this.tested.login(USERNAME, PASSWORD);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)USERNAME, (Object)user.getIdentifier());
        Assert.assertEquals((long)0L, (long)user.getRoles().size());
        Assert.assertEquals((long)0L, (long)user.getGroups().size());
    }

    @Test
    public void testLogout() throws Exception {
        this.tested.logout();
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).logout();
        ((HttpSession)Mockito.verify((Object)this.httpSession, (VerificationMode)Mockito.times((int)1))).invalidate();
    }

    @Test
    public void testLogoutNoSession() throws Exception {
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)this.request)).getSession(false);
        this.tested.logout();
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).logout();
        ((HttpSession)Mockito.verify((Object)this.httpSession, (VerificationMode)Mockito.never())).invalidate();
    }

    @Test
    public void testSwallowIllegalStateExceptionDuringLogoutWithKeycloak() {
        ((HttpSession)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("UT000021: Session already invalidated")}).when((Object)this.httpSession)).invalidate();
        this.tested.logout();
    }

    @Test
    public void testReThrowUnexpectedIllegalStateExceptionDuringLogout() {
        String exceptionMsg = "This exception should be propagated!";
        ((HttpSession)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException(exceptionMsg)}).when((Object)this.httpSession)).invalidate();
        try {
            this.tested.logout();
        }
        catch (IllegalStateException ise) {
            Assert.assertEquals((Object)exceptionMsg, (Object)ise.getMessage());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testGetRequestForThreadNoRequest() {
        SecurityIntegrationFilter.requests.set(null);
        ServletSecurityAuthenticationServiceTest servletSecurityAuthenticationServiceTest = this;
        servletSecurityAuthenticationServiceTest.tested.getRequestForThread();
        SecurityIntegrationFilter.requests.set(this.request);
    }

    @Test
    public void testGetUserNoUserPrincipal() {
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)this.request)).getUserPrincipal();
        Assert.assertNull((Object)this.tested.getUser());
    }

    @Test
    public void testGetUserNoSession() {
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)this.request)).getSession();
        Assert.assertNull((Object)this.tested.getUser());
    }
}

