/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.AllDocksMenu;
import org.uberfire.client.docks.UberfireDocksImpl;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberfireDocksImplTest {
    private UberfireDocksImpl docks;
    @Mock
    private DockLayoutPanel dockLayoutPanel;
    private UberfireDock dock1;
    private UberfireDock dock4;
    private UberfireDock dock3;
    private UberfireDock dock2;

    @Before
    public void setUp() throws Exception {
        this.docks = new UberfireDocksImpl();
        this.dock1 = new UberfireDock(UberfireDockPosition.SOUTH, (PlaceRequest)new DefaultPlaceRequest("Dock1"), "Home");
        this.dock2 = new UberfireDock(UberfireDockPosition.SOUTH, (PlaceRequest)new DefaultPlaceRequest("Dock2"), "Another");
        this.dock3 = new UberfireDock(UberfireDockPosition.EAST, (PlaceRequest)new DefaultPlaceRequest("Dock3"), "Another");
        this.dock4 = new UberfireDock(UberfireDockPosition.SOUTH, (PlaceRequest)new DefaultPlaceRequest("Dock4"), "Another");
    }

    @Test
    public void testInit() throws Exception {
        this.docks.init();
        Assert.assertEquals((Object)UberfireDockPosition.EAST, (Object)this.docks.eastCollapsed.getPosition());
        Assert.assertEquals((Object)UberfireDockPosition.EAST, (Object)this.docks.eastExpanded.getPosition());
        Assert.assertEquals((Object)UberfireDockPosition.WEST, (Object)this.docks.westCollapsed.getPosition());
        Assert.assertEquals((Object)UberfireDockPosition.WEST, (Object)this.docks.westExpanded.getPosition());
        Assert.assertEquals((Object)UberfireDockPosition.SOUTH, (Object)this.docks.southCollapsed.getPosition());
        Assert.assertEquals((Object)UberfireDockPosition.SOUTH, (Object)this.docks.southExpanded.getPosition());
    }

    @Test
    public void testSetup() throws Exception {
        this.docks.init();
        this.docks.setup(this.dockLayoutPanel);
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel)).addSouth((Widget)this.docks.southCollapsed, this.docks.southCollapsed.widgetSize());
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel)).addSouth((Widget)this.docks.southExpanded, this.docks.southExpanded.defaultWidgetSize());
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel)).addEast((Widget)this.docks.eastCollapsed, this.docks.eastCollapsed.widgetSize());
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel)).addEast((Widget)this.docks.eastExpanded, this.docks.eastExpanded.defaultWidgetSize());
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel)).addWest((Widget)this.docks.westCollapsed, this.docks.westCollapsed.widgetSize());
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel)).addWest((Widget)this.docks.westExpanded, this.docks.westExpanded.defaultWidgetSize());
        this.verifyCollapseAllDocks(this.dockLayoutPanel, 1);
    }

    @Test
    public void testRegisterWithoutAssociatedPerspective() throws Exception {
        this.docks.init();
        this.docks.setup(this.dockLayoutPanel);
        UberfireDock dockWithoutPerspective = new UberfireDock(UberfireDockPosition.SOUTH, (PlaceRequest)new DefaultPlaceRequest("Dock4"));
        this.docks.register(new UberfireDock[]{dockWithoutPerspective});
        Assert.assertTrue((boolean)this.docks.avaliableDocks.contains(dockWithoutPerspective));
        Assert.assertTrue((boolean)this.docks.docksPerPerspective.isEmpty());
        AllDocksMenu allDocksMenu = this.docks.southCollapsed.getAllDocksMenu();
        Assert.assertEquals((long)1L, (long)allDocksMenu.getCurrentDocks().size());
    }

    @Test
    public void testRegister() throws Exception {
        this.docks.init();
        this.docks.setup(this.dockLayoutPanel);
        this.docks.register(new UberfireDock[]{this.dock1, this.dock2});
        Assert.assertTrue((boolean)this.docks.avaliableDocks.contains(this.dock1));
        Assert.assertTrue((boolean)this.docks.avaliableDocks.contains(this.dock2));
        Set home = (Set)this.docks.docksPerPerspective.get("Home");
        Assert.assertTrue((boolean)home.contains(this.dock1));
        AllDocksMenu allDocksMenu = this.docks.southCollapsed.getAllDocksMenu();
        Assert.assertEquals((long)2L, (long)allDocksMenu.getCurrentDocks().size());
    }

    @Test
    public void testRegisterTwoDocksWithSameNameDisplayOnceOnAvaliablePerspectives() throws Exception {
        this.docks.init();
        this.docks.setup(this.dockLayoutPanel);
        UberfireDock dock5 = new UberfireDock(UberfireDockPosition.SOUTH, (PlaceRequest)new DefaultPlaceRequest("Dock4"), "Another");
        this.docks.register(new UberfireDock[]{this.dock1, this.dock2, this.dock3, this.dock4, dock5});
        AllDocksMenu allDocksMenu = this.docks.southCollapsed.getAllDocksMenu();
        Assert.assertEquals((long)4L, (long)allDocksMenu.getCurrentDocks().size());
    }

    @Test
    public void testPerspectiveChangeEvent() throws Exception {
        this.docks.init();
        this.docks.setup(this.dockLayoutPanel);
        this.docks.register(new UberfireDock[]{this.dock1, this.dock2, this.dock3, this.dock4});
        this.docks.perspectiveChangeEvent(new PerspectiveChange(null, null, null, "Another"));
        Assert.assertEquals((long)2L, (long)this.docks.southCollapsed.getDocksItems().size());
        Assert.assertEquals((long)1L, (long)this.docks.eastCollapsed.getDocksItems().size());
        Assert.assertEquals((long)0L, (long)this.docks.westCollapsed.getDocksItems().size());
        this.docks.perspectiveChangeEvent(new PerspectiveChange(null, null, null, "Home"));
        Assert.assertEquals((long)1L, (long)this.docks.southCollapsed.getDocksItems().size());
        Assert.assertEquals((long)0L, (long)this.docks.eastCollapsed.getDocksItems().size());
        Assert.assertEquals((long)0L, (long)this.docks.westCollapsed.getDocksItems().size());
        this.verifyCollapseAllDocks(this.dockLayoutPanel, 3);
        this.verifyExpandAllCollapsed(this.dockLayoutPanel, 2);
    }

    @Test
    public void testMoveDock() {
        this.docks.init();
        this.docks.setup(this.dockLayoutPanel);
        this.docks.register(new UberfireDock[]{this.dock1, this.dock2, this.dock3, this.dock4});
        this.docks.perspectiveChangeEvent(new PerspectiveChange(null, null, null, "Another"));
        Assert.assertEquals((long)2L, (long)this.docks.southCollapsed.getDocksItems().size());
        Assert.assertEquals((long)1L, (long)this.docks.eastCollapsed.getDocksItems().size());
        Assert.assertEquals((long)0L, (long)this.docks.westCollapsed.getDocksItems().size());
        this.docks.moveDock(this.dock2, UberfireDockPosition.EAST);
        Assert.assertEquals((long)1L, (long)this.docks.southCollapsed.getDocksItems().size());
        Assert.assertEquals((long)2L, (long)this.docks.eastCollapsed.getDocksItems().size());
        Assert.assertEquals((long)0L, (long)this.docks.westCollapsed.getDocksItems().size());
    }

    private void verifyExpandAllCollapsed(DockLayoutPanel dockLayoutPanel, int wantedNumberOfInvocations) {
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.southCollapsed, false);
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.eastCollapsed, false);
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.westCollapsed, false);
    }

    private void verifyCollapseAllDocks(DockLayoutPanel dockLayoutPanel, int wantedNumberOfInvocations) {
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.southCollapsed, true);
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.southExpanded, true);
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.eastCollapsed, true);
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.eastExpanded, true);
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.westCollapsed, true);
        ((DockLayoutPanel)Mockito.verify((Object)dockLayoutPanel, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).setWidgetHidden((Widget)this.docks.westExpanded, true);
    }
}

