/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;

public class DocksExpandedBar
extends Composite {
    private UberfireDockPosition position;
    @UiField
    FlowPanel titlePanel;
    @UiField
    FlowPanel targetPanel;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);

    public DocksExpandedBar(UberfireDockPosition position) {
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.position = position;
    }

    public void setup(String identifier, ParameterizedCommand<String> deselectCommand) {
        this.titlePanel.clear();
        Label label = new Label(identifier);
        label.addStyleName(CSS.CSS().dockLabel());
        this.titlePanel.add((Widget)label);
        this.createButtons(identifier, deselectCommand);
    }

    public void createButtons(final String identifier, final ParameterizedCommand<String> deselectCommand) {
        Button collapse = new Button();
        collapse.setIcon(IconType.SORT_DOWN);
        collapse.setSize(ButtonSize.MINI);
        collapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                deselectCommand.execute((Object)identifier);
            }
        });
        collapse.addStyleName(CSS.CSS().dockExpandedButton());
        this.titlePanel.add((Widget)collapse);
    }

    public void setPanelSize(int width, int height) {
        this.targetPanel.setPixelSize(width, height);
    }

    public FlowPanel targetPanel() {
        return this.targetPanel;
    }

    public void clear() {
        this.targetPanel.clear();
    }

    public double defaultWidgetSize() {
        return 150.0;
    }

    public UberfireDockPosition getPosition() {
        return this.position;
    }

    static interface ViewBinder
    extends UiBinder<Widget, DocksExpandedBar> {
    }
}

