/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.docks.DocksBar;
import org.uberfire.client.docks.DocksExpandedBar;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class UberfireDocksImpl
implements UberfireDocks {
    @Inject
    private PlaceManager placeManager;
    @Inject
    private SyncBeanManager iocManager;
    private DockLayoutPanel rootContainer;
    DocksBar southCollapsed;
    DocksExpandedBar southExpanded;
    DocksBar westCollapsed;
    DocksExpandedBar westExpanded;
    DocksBar eastCollapsed;
    DocksExpandedBar eastExpanded;
    Map<String, Set<UberfireDock>> docksPerPerspective = new HashMap<String, Set<UberfireDock>>();
    Set<UberfireDock> avaliableDocks = new HashSet<UberfireDock>();
    private String currentPerspective;
    Map<String, Set<UberfireDockPosition>> disableDocksPerPerspective = new HashMap<String, Set<UberfireDockPosition>>();

    @PostConstruct
    public void init() {
        this.createSouthDock();
        this.createEastDock();
        this.createWestDock();
    }

    public void setup(DockLayoutPanel rootContainer) {
        this.rootContainer = rootContainer;
        rootContainer.addSouth((Widget)new FlowPanel(), 1.0);
        rootContainer.addSouth((Widget)this.southCollapsed, this.southCollapsed.widgetSize());
        rootContainer.addSouth((Widget)this.southExpanded, this.southExpanded.defaultWidgetSize());
        rootContainer.addWest((Widget)new FlowPanel(), 1.0);
        rootContainer.addWest((Widget)this.westCollapsed, this.westCollapsed.widgetSize());
        rootContainer.addWest((Widget)this.westExpanded, this.westExpanded.defaultWidgetSize());
        rootContainer.addEast((Widget)new FlowPanel(), 1.0);
        rootContainer.addEast((Widget)this.eastCollapsed, this.eastCollapsed.widgetSize());
        rootContainer.addEast((Widget)this.eastExpanded, this.eastExpanded.defaultWidgetSize());
        this.updateDocks();
    }

    public void disable(UberfireDockPosition position, String perspectiveName) {
        if (this.docksContainerIsAttached()) {
            DocksBar docksBar = this.resolveDockBar(position.name());
            DocksExpandedBar docksExpandedBar = this.resolveDockExpandedBar(position.name());
            this.collapse(docksBar);
            this.collapse(docksExpandedBar);
            this.addToDisableDocksList(position, perspectiveName);
        }
    }

    private void addToDisableDocksList(UberfireDockPosition position, String perspectiveName) {
        Set<UberfireDockPosition> disableDocks = this.disableDocksPerPerspective.get(perspectiveName);
        if (disableDocks == null) {
            disableDocks = new HashSet<UberfireDockPosition>();
            this.disableDocksPerPerspective.put(perspectiveName, disableDocks);
        }
        disableDocks.add(position);
    }

    public void enable(UberfireDockPosition position, String perspectiveName) {
        this.removeFromDisableDocksList(position, perspectiveName);
        DocksBar docksBar = this.resolveDockBar(position.name());
        this.expand(docksBar);
    }

    private void removeFromDisableDocksList(UberfireDockPosition position, String perspectiveName) {
        Set<UberfireDockPosition> disableDocks = this.disableDocksPerPerspective.get(perspectiveName);
        if (disableDocks != null) {
            disableDocks.remove(position);
        }
    }

    public void register(UberfireDock ... docks) {
        for (UberfireDock dock : docks) {
            this.avaliableDocks.add(dock);
            if (dock.getAssociatedPerspective() == null) continue;
            Set<UberfireDock> uberfireDocks = this.docksPerPerspective.get(dock.getAssociatedPerspective());
            if (uberfireDocks == null) {
                uberfireDocks = new HashSet<UberfireDock>();
            }
            uberfireDocks.add(dock);
            this.docksPerPerspective.put(dock.getAssociatedPerspective(), uberfireDocks);
        }
        this.updateAvaliableDocksMenu();
    }

    private void updateAvaliableDocksMenu() {
        this.southCollapsed.updateAvaliableDocksMenu(this.avaliableDocks, this.createOpenDockLink());
    }

    public void perspectiveChangeEvent(@Observes PerspectiveChange perspectiveChange) {
        this.currentPerspective = perspectiveChange.getIdentifier();
        if (this.docksContainerIsAttached()) {
            this.updateDocks();
        }
    }

    private void updateDocks() {
        this.clearAndCollapseAllDocks();
        this.updateDockContent();
    }

    private boolean docksContainerIsAttached() {
        return this.rootContainer != null;
    }

    private void clearAndCollapseAllDocks() {
        this.collapseAll();
        this.southCollapsed.clearDocks();
        this.westCollapsed.clearDocks();
        this.eastCollapsed.clearDocks();
    }

    private void updateDockContent() {
        Set<UberfireDock> docks;
        if (this.currentPerspective != null && (docks = this.docksPerPerspective.get(this.currentPerspective)) != null && !docks.isEmpty()) {
            for (UberfireDock dock : docks) {
                DocksBar docksBar = this.resolveDockBar(dock.getDockPosition().name());
                DocksExpandedBar docksExpandedBar = this.resolveDockExpandedBar(dock.getDockPosition().name());
                if (docksBar == null) continue;
                docksBar.addDock(dock, this.createDockSelectCommand(docksBar, docksExpandedBar), this.createDockDeselectCommand(docksBar, docksExpandedBar));
            }
            this.expandAllCollapsed();
        }
    }

    private void createEastDock() {
        this.eastExpanded = new DocksExpandedBar(UberfireDockPosition.EAST);
        this.eastCollapsed = new DocksBar(UberfireDockPosition.EAST, this.createDropHandler(UberfireDockPosition.EAST));
    }

    private void createWestDock() {
        this.westExpanded = new DocksExpandedBar(UberfireDockPosition.WEST);
        this.westCollapsed = new DocksBar(UberfireDockPosition.WEST, this.createDropHandler(UberfireDockPosition.WEST));
    }

    private void createSouthDock() {
        this.southExpanded = new DocksExpandedBar(UberfireDockPosition.SOUTH);
        this.southCollapsed = new DocksBar(UberfireDockPosition.SOUTH, this.createDropHandler(UberfireDockPosition.SOUTH));
    }

    private ParameterizedCommand<String> createDropHandler(final UberfireDockPosition targetDock) {
        return new ParameterizedCommand<String>(){

            public void execute(String dropName) {
                UberfireDock dock = UberfireDocksImpl.this.searchForDockByDockItemName(dropName);
                if (dock != null) {
                    UberfireDocksImpl.this.moveDock(dock, targetDock);
                }
            }
        };
    }

    void moveDock(UberfireDock dock, UberfireDockPosition targetDock) {
        DocksBar oldDockBar = this.resolveDockBar(dock.getDockPosition().name());
        oldDockBar.removeDock(dock);
        dock.setUberfireDockPosition(targetDock);
        this.avaliableDocks.add(dock);
        if (dock.getAssociatedPerspective() != null) {
            Set<UberfireDock> uberfireDocks = this.docksPerPerspective.get(dock.getAssociatedPerspective());
            uberfireDocks.add(dock);
        }
        DocksBar targetDockBar = this.resolveDockBar(targetDock.name());
        DocksExpandedBar targetExpandedDockBar = this.resolveDockExpandedBar(targetDock.name());
        targetDockBar.addDock(dock, this.createDockSelectCommand(targetDockBar, targetExpandedDockBar), this.createDockDeselectCommand(targetDockBar, targetExpandedDockBar));
    }

    private ParameterizedCommand<String> createDockSelectCommand(final DocksBar dockBar, final DocksExpandedBar dockExpandedBar) {
        return new ParameterizedCommand<String>(){

            public void execute(String clickDockName) {
                UberfireDock targetDock = UberfireDocksImpl.this.searchForDockByDockItemName(clickDockName);
                if (targetDock != null) {
                    UberfireDocksImpl.this.selectDock(targetDock, dockBar, dockExpandedBar);
                }
            }
        };
    }

    private void selectDock(UberfireDock targetDock, DocksBar dockBar, DocksExpandedBar dockExpandedBar) {
        dockBar.setDockSelected(targetDock.getIdentifier());
        dockExpandedBar.clear();
        this.expand(dockExpandedBar);
        this.setupExpandedBarSize(targetDock, dockExpandedBar);
        dockExpandedBar.setup(targetDock.getIdentifier(), this.createDockDeselectCommand(dockBar, dockExpandedBar));
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(targetDock.getIdentifier()), (HasWidgets)dockExpandedBar.targetPanel());
    }

    private void setupExpandedBarSize(UberfireDock targetDock, DocksExpandedBar dockExpandedBar) {
        int width = this.rootContainer.getElement().getClientWidth();
        if (this.thereIsASpecificSize(targetDock)) {
            dockExpandedBar.setPanelSize(targetDock.getSize().intValue(), targetDock.getSize().intValue());
            this.rootContainer.setWidgetSize((Widget)dockExpandedBar, targetDock.getSize().doubleValue());
        } else {
            Double height = new Double(dockExpandedBar.defaultWidgetSize());
            dockExpandedBar.setPanelSize(width, height.intValue());
            this.rootContainer.setWidgetSize((Widget)dockExpandedBar, dockExpandedBar.defaultWidgetSize());
        }
    }

    private boolean thereIsASpecificSize(UberfireDock targetDock) {
        return targetDock.getSize() != null;
    }

    private ParameterizedCommand<String> createDockDeselectCommand(final DocksBar dockBar, final DocksExpandedBar dockExpandedBar) {
        return new ParameterizedCommand<String>(){

            public void execute(String clickDockName) {
                UberfireDock targetDock = UberfireDocksImpl.this.searchForDockByDockItemName(clickDockName);
                if (targetDock != null) {
                    UberfireDocksImpl.this.deselectDock(dockBar, dockExpandedBar);
                }
            }
        };
    }

    private void deselectDock(DocksBar dockBar, DocksExpandedBar dockExpandedBar) {
        dockBar.deselectAllDocks();
        dockExpandedBar.clear();
        this.collapse(dockExpandedBar);
    }

    private ParameterizedCommand<String> createOpenDockLink() {
        return new ParameterizedCommand<String>(){

            public void execute(String clickDockName) {
                UberfireDock targetDock = UberfireDocksImpl.this.searchForDockByDockItemName(clickDockName);
                if (targetDock != null) {
                    DocksBar dockBar = UberfireDocksImpl.this.resolveDockBar(targetDock.getDockPosition().name());
                    DocksExpandedBar dockExpandedBar = UberfireDocksImpl.this.resolveDockExpandedBar(targetDock.getDockPosition().name());
                    if (dockBar != null && dockExpandedBar != null) {
                        UberfireDocksImpl.this.selectDock(targetDock, dockBar, dockExpandedBar);
                    }
                }
            }
        };
    }

    private DocksExpandedBar resolveDockExpandedBar(String dockPosition) {
        if (dockPosition.equalsIgnoreCase(UberfireDockPosition.SOUTH.name())) {
            return this.southExpanded;
        }
        if (dockPosition.equalsIgnoreCase(UberfireDockPosition.WEST.name())) {
            return this.westExpanded;
        }
        return this.eastExpanded;
    }

    private DocksBar resolveDockBar(String dockPosition) {
        if (dockPosition.equalsIgnoreCase(UberfireDockPosition.SOUTH.name())) {
            return this.southCollapsed;
        }
        if (dockPosition.equalsIgnoreCase(UberfireDockPosition.WEST.name())) {
            return this.westCollapsed;
        }
        return this.eastCollapsed;
    }

    UberfireDock searchForDockByDockItemName(String clickDockName) {
        UberfireDock targetDock = null;
        for (UberfireDock avaliableDock : this.avaliableDocks) {
            if (!avaliableDock.getIdentifier().equalsIgnoreCase(clickDockName)) continue;
            targetDock = avaliableDock;
        }
        return targetDock;
    }

    private void collapseAll() {
        this.collapse(this.southExpanded);
        this.collapse(this.eastExpanded);
        this.collapse(this.westExpanded);
        this.collapse(this.southCollapsed);
        this.collapse(this.eastCollapsed);
        this.collapse(this.westCollapsed);
    }

    private void expandAllCollapsed() {
        this.expand(this.eastCollapsed);
        this.expand(this.westCollapsed);
        this.expand(this.southCollapsed);
    }

    private void collapse(DocksBar dock) {
        this.rootContainer.setWidgetHidden((Widget)dock, true);
    }

    private void expand(DocksBar dock) {
        if (this.dockIsEnable(dock.getPosition())) {
            this.rootContainer.setWidgetHidden((Widget)dock, false);
        }
    }

    private void expand(DocksExpandedBar dock) {
        if (this.dockIsEnable(dock.getPosition())) {
            this.rootContainer.setWidgetHidden((Widget)dock, false);
        }
    }

    private boolean dockIsEnable(UberfireDockPosition dockPosition) {
        Set<UberfireDockPosition> uberfireDockPositions = this.disableDocksPerPerspective.get(this.currentPerspective);
        return uberfireDockPositions == null || !uberfireDockPositions.contains(dockPosition);
    }

    private void collapse(DocksExpandedBar dock) {
        dock.clear();
        this.rootContainer.setWidgetHidden((Widget)dock, true);
    }
}

