/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.NavList;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.mvp.ParameterizedCommand;

public class AllDocksMenu
extends PopupPanel {
    private static AllDocksMenuBinder uiBinder = (AllDocksMenuBinder)GWT.create(AllDocksMenuBinder.class);
    @UiField
    FlowPanel popup;
    @UiField
    NavList navList;
    private List<DocksMenu> currentDocks;

    public AllDocksMenu() {
        super(true);
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.onMouseOutHidePopup();
    }

    private void onMouseOutHidePopup() {
        this.addDomHandler((EventHandler)new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                AllDocksMenu.this.hide();
            }
        }, MouseOutEvent.getType());
    }

    public void show(final Widget widgetToPosition) {
        this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                int top = widgetToPosition.getElement().getAbsoluteTop() - AllDocksMenu.this.getElement().getClientHeight();
                AllDocksMenu.this.setPopupPosition(widgetToPosition.getAbsoluteLeft(), top);
            }
        });
    }

    public void createDocksMenu(final String label, final ParameterizedCommand<String> openDockLink) {
        DocksMenu docksMenu = new DocksMenu(label, openDockLink);
        if (!this.alreadyHasThisDock(docksMenu)) {
            this.currentDocks.add(docksMenu);
            NavLink navLink = (NavLink)GWT.create(NavLink.class);
            navLink.setText(label);
            navLink.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    openDockLink.execute((Object)label);
                }
            });
            this.navList.add((Widget)navLink);
        }
    }

    private boolean alreadyHasThisDock(DocksMenu docksMenu) {
        return this.currentDocks.contains(docksMenu);
    }

    public void clearDocksMenu() {
        this.navList.clear();
        this.currentDocks = new ArrayList<DocksMenu>();
    }

    public List<DocksMenu> getCurrentDocks() {
        return this.currentDocks;
    }

    private class DocksMenu {
        private final String label;
        private final ParameterizedCommand<String> command;

        DocksMenu(String label, ParameterizedCommand<String> command) {
            this.label = label;
            this.command = command;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DocksMenu)) {
                return false;
            }
            DocksMenu docksMenu = (DocksMenu)o;
            return !(this.label == null ? docksMenu.label != null : !this.label.equals(docksMenu.label));
        }

        public int hashCode() {
            return this.label != null ? this.label.hashCode() : 0;
        }
    }

    static interface AllDocksMenuBinder
    extends UiBinder<Widget, AllDocksMenu> {
    }
}

