/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DragLeaveEvent;
import com.google.gwt.event.dom.client.DragLeaveHandler;
import com.google.gwt.event.dom.client.DragOverEvent;
import com.google.gwt.event.dom.client.DragOverHandler;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.event.dom.client.DropHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.uberfire.client.docks.AllDocksMenu;
import org.uberfire.client.docks.DocksItem;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;

public class DocksBar
extends Composite {
    private UberfireDockPosition position;
    private final ParameterizedCommand<String> dropHandler;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    FlowPanel allDocksMenuPanel;
    @UiField
    FlowPanel docksBarPanel;
    private List<DocksItem> docksItems = new ArrayList<DocksItem>();
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    private AllDocksMenu allDocksMenu;

    public DocksBar(UberfireDockPosition position, ParameterizedCommand<String> dropHandler) {
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.position = position;
        this.dropHandler = dropHandler;
        this.setCSS(position);
        if (position == UberfireDockPosition.SOUTH) {
            this.createAvaliableDocksButton();
        }
        this.createDragHandler();
    }

    private void createDragHandler() {
        this.addDropHandler(new DropHandler(){

            public void onDrop(DropEvent event) {
                DocksBar.this.dropHandler(event);
            }
        });
    }

    void dropHandler(DropEvent event) {
        event.preventDefault();
        this.dropHandler.execute((Object)event.getData(DocksItem.class.getSimpleName()));
    }

    public void updateAvaliableDocksMenu(Set<UberfireDock> avaliableDocks, ParameterizedCommand<String> openAvaliableDocks) {
        this.allDocksMenu.clearDocksMenu();
        for (UberfireDock avaliableDock : avaliableDocks) {
            this.allDocksMenu.createDocksMenu(avaliableDock.getIdentifier(), openAvaliableDocks);
        }
    }

    public void createAvaliableDocksButton() {
        this.allDocksMenu = new AllDocksMenu();
        Button allDocksButton = (Button)GWT.create(Button.class);
        allDocksButton.setIcon(IconType.COGS);
        allDocksButton.setSize(ButtonSize.MINI);
        allDocksButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (DocksBar.this.allDocksMenu.isShowing()) {
                    DocksBar.this.allDocksMenu.hide();
                } else {
                    DocksBar.this.allDocksMenu.show((Widget)DocksBar.this);
                }
            }
        });
        this.allDocksMenuPanel.add((Widget)allDocksButton);
    }

    public void clearDocks() {
        this.docksBarPanel.clear();
        this.docksItems = new ArrayList<DocksItem>();
    }

    public void setDockSelected(String identifier) {
        for (DocksItem docksItem : this.docksItems) {
            if (docksItem.getIdentifier().equalsIgnoreCase(identifier)) {
                docksItem.selected();
                continue;
            }
            docksItem.deselect();
        }
    }

    public void deselectAllDocks() {
        for (DocksItem docksItem : this.docksItems) {
            docksItem.deselect();
        }
    }

    public void addDock(UberfireDock dock, ParameterizedCommand<String> selectCommand, ParameterizedCommand<String> deselectCommand) {
        DocksItem dockItem = new DocksItem(dock.getIdentifier(), selectCommand, deselectCommand);
        this.docksItems.add(dockItem);
        this.docksBarPanel.add((Widget)dockItem);
    }

    public void removeDock(UberfireDock dock) {
        DocksItem toRemove = null;
        for (DocksItem docksItem : this.docksItems) {
            if (!docksItem.getIdentifier().equalsIgnoreCase(dock.getIdentifier())) continue;
            toRemove = docksItem;
        }
        if (toRemove != null) {
            this.docksItems.remove((Object)toRemove);
            this.docksBarPanel.remove(toRemove);
        }
    }

    public double widgetSize() {
        return 30.0;
    }

    private void setCSS(UberfireDockPosition position) {
        String style = position == UberfireDockPosition.SOUTH ? CSS.CSS().southDockInnerPanel() : (position == UberfireDockPosition.WEST ? CSS.CSS().westDockInnerPanel() : CSS.CSS().eastDockInnerPanel());
        this.addStyleName(CSS.CSS().dock());
        this.docksBarPanel.addStyleName(style);
    }

    private HandlerRegistration addDropHandler(DropHandler handler) {
        return this.addBitlessDomHandler((EventHandler)handler, DropEvent.getType());
    }

    private HandlerRegistration addDragOverHandler(DragOverHandler handler) {
        return this.addBitlessDomHandler((EventHandler)handler, DragOverEvent.getType());
    }

    private HandlerRegistration addDragLeaveHandler(DragLeaveHandler handler) {
        return this.addBitlessDomHandler((EventHandler)handler, DragLeaveEvent.getType());
    }

    public UberfireDockPosition getPosition() {
        return this.position;
    }

    public List<DocksItem> getDocksItems() {
        return this.docksItems;
    }

    public AllDocksMenu getAllDocksMenu() {
        return this.allDocksMenu;
    }

    static interface ViewBinder
    extends UiBinder<Widget, DocksBar> {
    }
}

