/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DragStartEvent;
import com.google.gwt.event.dom.client.DragStartHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.mvp.ParameterizedCommand;

public class DocksItem
extends Composite {
    private final String identifier;
    private boolean selected;
    @UiField
    Label itemLabel;
    @UiField
    FlowPanel dockItem;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);

    public DocksItem(final String identifier, final ParameterizedCommand<String> selectCommand, final ParameterizedCommand<String> deselectCommand) {
        this.identifier = identifier;
        this.selected = false;
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.itemLabel.setText(identifier);
        this.itemLabel.addStyleName(CSS.CSS().dockLabel());
        this.itemLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!DocksItem.this.selected) {
                    selectCommand.execute((Object)identifier);
                } else {
                    deselectCommand.execute((Object)identifier);
                }
            }
        });
        this.setDndSupport();
    }

    private void setDndSupport() {
        this.dockItem.addDomHandler((EventHandler)new DragStartHandler(){

            public void onDragStart(DragStartEvent event) {
                DocksItem.this.createDragStart(event);
            }
        }, DragStartEvent.getType());
        this.dockItem.getElement().setDraggable("true");
    }

    private void createDragStart(DragStartEvent event) {
        event.setData(DocksItem.class.getSimpleName(), this.itemLabel.getText());
        Icon icon = new Icon(IconType.MOVE);
        icon.setIconSize(IconSize.DEFAULT);
        event.getDataTransfer().setDragImage((Element)icon.getElement(), 10, 10);
    }

    public void selected() {
        this.selected = true;
        this.itemLabel.removeStyleName(CSS.CSS().dockLabel());
        this.itemLabel.addStyleName(CSS.CSS().dockLabelSelected());
        this.dockItem.removeStyleName(CSS.CSS().dockItem());
        this.dockItem.addStyleName(CSS.CSS().dockItemSelected());
    }

    public void deselect() {
        this.selected = false;
        this.itemLabel.addStyleName(CSS.CSS().dockLabel());
        this.itemLabel.removeStyleName(CSS.CSS().dockLabelSelected());
        this.dockItem.removeStyleName(CSS.CSS().dockItemSelected());
        this.dockItem.addStyleName(CSS.CSS().dockItem());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    static interface ViewBinder
    extends UiBinder<Widget, DocksItem> {
    }
}

