/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.menu;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Dropdown;
import com.github.gwtbootstrap.client.ui.DropdownButton;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;
import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;

@ApplicationScoped
public class MenuBuilder {
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;

    public Widget makeItem(final MenuItem item, boolean isRoot) {
        Object result;
        if (!this.authzManager.authorize((Resource)item, this.identity)) {
            return null;
        }
        if (item instanceof MenuItemCommand) {
            Object gwtItem;
            final MenuItemCommand cmdItem = (MenuItemCommand)item;
            if (isRoot) {
                gwtItem = new Button(cmdItem.getCaption()){
                    {
                        super(x0);
                        this.setSize(ButtonSize.MINI);
                        this.setEnabled(item.isEnabled());
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                cmdItem.getCommand().execute();
                            }
                        });
                    }
                };
                item.addEnabledStateChangeListener(new EnabledStateChangeListener((Widget)gwtItem){
                    final /* synthetic */ Widget val$gwtItem;
                    {
                        this.val$gwtItem = widget;
                    }

                    public void enabledStateChanged(boolean enabled) {
                        ((Button)this.val$gwtItem).setEnabled(enabled);
                    }
                });
            } else {
                gwtItem = new NavLink(cmdItem.getCaption()){
                    {
                        super(x0);
                        this.setDisabled(!item.isEnabled());
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                cmdItem.getCommand().execute();
                            }
                        });
                    }
                };
                item.addEnabledStateChangeListener(new EnabledStateChangeListener((Widget)gwtItem){
                    final /* synthetic */ Widget val$gwtItem;
                    {
                        this.val$gwtItem = widget;
                    }

                    public void enabledStateChanged(boolean enabled) {
                        ((NavLink)this.val$gwtItem).setDisabled(!enabled);
                    }
                });
            }
            return gwtItem;
        }
        if (item instanceof MenuGroup) {
            Object gwtItem;
            MenuGroup groups = (MenuGroup)item;
            if (isRoot) {
                final ArrayList<Widget> widgetList = new ArrayList<Widget>();
                for (MenuItem _item : groups.getItems()) {
                    Widget widget = this.makeItem(_item, false);
                    if (widget == null) continue;
                    widgetList.add(widget);
                }
                if (widgetList.isEmpty()) {
                    return null;
                }
                gwtItem = new DropdownButton(groups.getCaption()){
                    {
                        super(x0);
                        this.setSize(ButtonSize.MINI);
                        for (Widget _item : widgetList) {
                            this.add(_item);
                        }
                    }
                };
            } else {
                final ArrayList<Widget> widgetList = new ArrayList<Widget>();
                for (MenuItem _item : groups.getItems()) {
                    Widget result2 = this.makeItem(_item, false);
                    if (result2 == null) continue;
                    widgetList.add(result2);
                }
                if (widgetList.isEmpty()) {
                    return null;
                }
                gwtItem = new Dropdown(groups.getCaption()){
                    {
                        super(x0);
                        for (Widget widget : widgetList) {
                            this.add(widget);
                        }
                    }
                };
            }
            return gwtItem;
        }
        if (item instanceof MenuCustom && (result = ((MenuCustom)item).build()) instanceof Widget) {
            return (Widget)result;
        }
        return null;
    }
}

