/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view;

import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.DocksBars;
import org.uberfire.client.docks.view.bars.DocksCollapsedBar;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.toolbar.IconType;

@RunWith(value=GwtMockitoTestRunner.class)
public class DocksBarsTest {
    @Mock
    private DockLayoutPanel dockLayoutPanel;
    private DocksBars docksBars;
    private final String SOME_PERSPECTIVE = "SomePerspective";
    private UberfireDock dock0 = new UberfireDock(UberfireDockPosition.SOUTH, IconType.CHEVRON_RIGHT.name(), (PlaceRequest)new DefaultPlaceRequest("welcome"), "SomePerspective").withLabel("albel");

    @Before
    public void setup() {
        this.docksBars = new DocksBars();
    }

    @Test
    public void setupDocks() {
        this.docksBars.setup(this.dockLayoutPanel);
        Assert.assertEquals((long)3L, (long)this.docksBars.getDocksBars().size());
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel, (VerificationMode)Mockito.times((int)3))).addEast((Widget)Matchers.any(Widget.class), ((Double)Matchers.any(Double.class)).doubleValue());
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel, (VerificationMode)Mockito.times((int)3))).addWest((Widget)Matchers.any(Widget.class), ((Double)Matchers.any(Double.class)).doubleValue());
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel, (VerificationMode)Mockito.times((int)3))).addSouth((Widget)Matchers.any(Widget.class), ((Double)Matchers.any(Double.class)).doubleValue());
    }

    @Test
    public void addDock() {
        this.docksBars.setup(this.dockLayoutPanel);
        DocksBar dockBar = this.docksBars.getDockBar(this.dock0);
        DocksBar targetDockSpy = (DocksBar)Mockito.spy((Object)dockBar);
        DocksBars dockBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        Mockito.when((Object)dockBarsSpy.getDockBar(this.dock0)).thenReturn((Object)targetDockSpy);
        dockBarsSpy.addDock(this.dock0);
        ((DocksBar)Mockito.verify((Object)targetDockSpy)).addDock((UberfireDock)Matchers.eq((Object)this.dock0), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void getDockBar() {
        this.docksBars.setup(this.dockLayoutPanel);
        DocksBar targetDockBar = this.docksBars.getDockBar(this.dock0);
        Assert.assertEquals((Object)this.dock0.getDockPosition(), (Object)targetDockBar.getPosition());
    }

    @Test
    public void clearAndCollapseAllDocks() {
        this.docksBars.setup(this.dockLayoutPanel);
        DocksBars docksBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        ArrayList<DocksBar> dockBars = new ArrayList<DocksBar>();
        DocksBar dock1 = this.createDocksBarMock();
        dockBars.add(dock1);
        DocksBar dock2 = this.createDocksBarMock();
        dockBars.add(dock2);
        Mockito.when((Object)docksBarsSpy.getDocksBars()).thenReturn(dockBars);
        docksBarsSpy.clearAndCollapseAllDocks();
        ((DocksBar)Mockito.verify((Object)dock1)).clearAll();
        ((DocksBar)Mockito.verify((Object)dock2)).clearAll();
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel, (VerificationMode)Mockito.times((int)6))).setWidgetHidden((Widget)Matchers.any(Widget.class), Matchers.eq((boolean)true));
    }

    @Test
    public void expand() {
        this.docksBars.setup(this.dockLayoutPanel);
        this.docksBars.addDock(this.dock0);
        this.docksBars.expand(this.docksBars.getDockBar(this.dock0));
        ((DockLayoutPanel)Mockito.verify((Object)this.dockLayoutPanel, (VerificationMode)Mockito.times((int)1))).setWidgetHidden((Widget)Matchers.any(Widget.class), Matchers.eq((boolean)false));
    }

    @Test
    public void isReady() {
        Assert.assertFalse((boolean)this.docksBars.isReady());
        this.docksBars.setup(this.dockLayoutPanel);
        Assert.assertTrue((boolean)this.docksBars.isReady());
    }

    private DocksBar createDocksBarMock() {
        DocksBar mock = (DocksBar)Mockito.mock(DocksBar.class);
        Mockito.when((Object)mock.getCollapsedBar()).thenReturn(Mockito.mock(DocksCollapsedBar.class));
        return mock;
    }
}

