/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.bars;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.docks.view.menu.MenuBuilder;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public class DocksExpandedBar
extends Composite
implements ProvidesResize,
RequiresResize {
    private UberfireDockPosition position;
    @UiField
    FlowPanel titlePanel;
    @UiField
    FlowPanel targetPanel;
    Button collapse;
    Heading title;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);

    public void onResize() {
    }

    public DocksExpandedBar(UberfireDockPosition position) {
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.position = position;
    }

    public void setup(String titleString, ParameterizedCommand<String> deselectCommand) {
        this.clear();
        this.createTitle(titleString);
        this.createButtons(titleString, deselectCommand);
        this.setupComponents();
        this.setupCSS();
    }

    private void setupComponents() {
        if (this.position == UberfireDockPosition.SOUTH) {
            this.titlePanel.add((Widget)this.collapse);
            this.titlePanel.add((Widget)this.title);
        } else if (this.position == UberfireDockPosition.WEST) {
            this.titlePanel.add((Widget)this.title);
            this.titlePanel.add((Widget)this.collapse);
        } else if (this.position == UberfireDockPosition.EAST) {
            this.titlePanel.add((Widget)this.collapse);
            this.titlePanel.add((Widget)this.title);
        }
    }

    public void addMenus(Menus menus, MenuBuilder menuBuilder) {
        for (MenuItem menuItem : menus.getItems()) {
            Widget result = menuBuilder.makeItem(menuItem, true);
            if (result == null) continue;
            ButtonGroup bg = new ButtonGroup();
            bg.addStyleName(CSS.CSS().dockExpandedContentButton());
            bg.add(result);
            this.titlePanel.add((Widget)bg);
        }
    }

    private void createTitle(String titleString) {
        this.title = new Heading(5);
        this.title.setText(titleString);
    }

    private void createButtons(final String identifier, final ParameterizedCommand<String> deselectCommand) {
        this.collapse = (Button)GWT.create(Button.class);
        this.collapse.setSize(ButtonSize.MINI);
        this.collapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                deselectCommand.execute((Object)identifier);
            }
        });
    }

    private void setupCSS() {
        if (this.position == UberfireDockPosition.SOUTH) {
            this.titlePanel.addStyleName(CSS.CSS().dockExpandedContentPanelSouth());
            this.title.addStyleName(CSS.CSS().dockExpandedLabelSouth());
            this.collapse.setIcon(IconType.CHEVRON_DOWN);
            this.collapse.addStyleName(CSS.CSS().dockExpandedButtonSouth());
        } else if (this.position == UberfireDockPosition.WEST) {
            this.title.addStyleName(CSS.CSS().dockExpandedLabelWest());
            this.collapse.setIcon(IconType.CHEVRON_LEFT);
            this.collapse.addStyleName(CSS.CSS().dockExpandedButtonWest());
        } else if (this.position == UberfireDockPosition.EAST) {
            this.title.addStyleName(CSS.CSS().dockExpandedLabelEast());
            this.collapse.setIcon(IconType.CHEVRON_RIGHT);
            this.collapse.addStyleName(CSS.CSS().dockExpandedButtonEast());
        }
        this.setupDockContentSize();
    }

    public void setupDockContentSize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                DocksExpandedBar.this.targetPanel.setSize(DocksExpandedBar.this.getOffsetWidth() + "px", DocksExpandedBar.this.getOffsetHeight() + "px");
            }
        });
    }

    public void setPanelSize(int width, int height) {
        this.targetPanel.setPixelSize(width, height);
    }

    public FlowPanel targetPanel() {
        return this.targetPanel;
    }

    public void clear() {
        this.targetPanel.clear();
        this.titlePanel.clear();
    }

    public UberfireDockPosition getPosition() {
        return this.position;
    }

    static interface ViewBinder
    extends UiBinder<Widget, DocksExpandedBar> {
    }
}

