/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconPosition;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.docks.view.items.SideDockItem;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDockPosition;

public class SideDockItemFocused
extends PopupPanel {
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    @UiField
    Button itemButton;
    private SideDockItem parent;

    public SideDockItemFocused(final SideDockItem parent) {
        super(true);
        this.parent = parent;
        this.add((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.itemButton.setIconPosition(IconPosition.LEFT);
        this.itemButton.setIcon(parent.getIcon());
        this.itemButton.setIconSize(IconSize.SMALL);
        this.itemButton.setText(parent.getLabel());
        this.removeStyleName("gwt-PopupPanel");
        this.onMouseOutHidePopup();
        this.itemButton.setIconPosition(IconPosition.LEFT);
        this.itemButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!parent.isSelected()) {
                    SideDockItemFocused.this.select();
                    parent.selectAndExecuteExpandCommand();
                } else {
                    SideDockItemFocused.this.deselect();
                    parent.deselectAndExecuteCommand();
                }
            }
        });
    }

    public void deselect() {
        this.itemButton.setType(ButtonType.DEFAULT);
    }

    public void select() {
        this.itemButton.setType(ButtonType.INFO);
    }

    public void open() {
        this.setupPositionAndShow();
    }

    private void onMouseOutHidePopup() {
        this.addDomHandler((EventHandler)new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                SideDockItemFocused.this.hide();
            }
        }, MouseOutEvent.getType());
        this.setAutoHideEnabled(true);
    }

    private void setupPositionAndShow() {
        this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                int left = 0;
                if (SideDockItemFocused.this.parent.getDock().getDockPosition() == UberfireDockPosition.EAST) {
                    left = Window.getClientWidth() - SideDockItemFocused.this.getOffsetWidth();
                }
                int top = SideDockItemFocused.this.parent.getAbsoluteTop();
                SideDockItemFocused.this.setPopupPosition(left, top);
            }
        });
    }

    static interface ViewBinder
    extends UiBinder<Widget, SideDockItemFocused> {
    }
}

