/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.Button;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.view.items.SideDockItem;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class SideDockItemTest {
    @Mock
    private ImageResource imageResource;
    @Mock
    private ImageResource imageResourceFocused;
    @Mock
    private PlaceRequest placeRequest;
    private ParameterizedCommand<String> emptyCommand;
    private UberfireDock dockWithFontIcon;
    private UberfireDock dockWithImageIcon;
    private SideDockItem sideDockWithFontIcon;
    private SideDockItem sideDockWithImageIcon;

    @Before
    public void setup() {
        this.dockWithFontIcon = new UberfireDock(UberfireDockPosition.EAST, "BRIEFCASE", this.placeRequest, "").withSize(450.0).withLabel("dock");
        this.dockWithImageIcon = new UberfireDock(UberfireDockPosition.EAST, this.imageResource, this.imageResourceFocused, this.placeRequest, "").withSize(450.0).withLabel("dock");
        this.sideDockWithFontIcon = (SideDockItem)Mockito.spy((Object)new SideDockItem(this.dockWithFontIcon, this.emptyCommand, this.emptyCommand));
        this.sideDockWithImageIcon = (SideDockItem)Mockito.spy((Object)new SideDockItem(this.dockWithImageIcon, this.emptyCommand, this.emptyCommand));
        this.emptyCommand = new ParameterizedCommand<String>(){

            public void execute(String parameter) {
            }
        };
    }

    @Test
    public void createSideDockItemWithFontIconTest() {
        this.sideDockWithFontIcon.createButton();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon)).configureIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)null));
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void createSideDockItemFocusedWithFontIconTest() {
        this.sideDockWithFontIcon.getPopup().createButton(this.sideDockWithFontIcon);
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon)).configureIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)null));
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void selectSideDockItemWithFontIconTest() {
        this.sideDockWithFontIcon.select();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void deselectSideDockItemWithFontIconTest() {
        this.sideDockWithFontIcon.deselect();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void createSideDockItemWithImageIconTest() {
        this.sideDockWithImageIcon.createButton();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
    }

    @Test
    public void createSideDockItemFocusedWithImageIconTest() {
        this.sideDockWithImageIcon.getPopup().createButton(this.sideDockWithImageIcon);
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResourceFocused));
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResourceFocused));
    }

    @Test
    public void selectSouthDockItemWithImageIconTest() {
        this.sideDockWithImageIcon.select();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResourceFocused));
    }

    @Test
    public void deselectSouthDockItemWithImageIconTest() {
        this.sideDockWithImageIcon.deselect();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
    }
}

