/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.DocksBars;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockContainerReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.events.PerspectiveChange;

@ApplicationScoped
public class UberfireDocksImpl
implements UberfireDocks {
    public static final String IDE_DOCK = "IDE_DOCK";
    final Map<String, List<UberfireDock>> docksPerPerspective = new HashMap<String, List<UberfireDock>>();
    final Map<String, Set<UberfireDockPosition>> disableDocksPerPerspective = new HashMap<String, Set<UberfireDockPosition>>();
    private DocksBars docksBars;
    String currentSelectedPerspective;
    @Inject
    private Event<UberfireDockReadyEvent> dockReadyEvent;

    @Inject
    public UberfireDocksImpl(DocksBars docksBars) {
        this.docksBars = docksBars;
    }

    protected void setup(@Observes UberfireDockContainerReadyEvent event) {
        this.docksBars.setup();
    }

    public void configure(Map<String, String> configurations) {
        if (configurations != null && configurations.get(IDE_DOCK) != null) {
            this.docksBars.setIDEdock(Boolean.valueOf(configurations.get(IDE_DOCK)));
        }
    }

    public void add(UberfireDock ... docks) {
        for (UberfireDock dock : docks) {
            if (dock.getAssociatedPerspective() == null) continue;
            List<UberfireDock> uberfireDocks = this.docksPerPerspective.get(dock.getAssociatedPerspective());
            if (uberfireDocks == null) {
                uberfireDocks = new ArrayList<UberfireDock>();
            }
            uberfireDocks.add(dock);
            this.docksPerPerspective.put(dock.getAssociatedPerspective(), uberfireDocks);
        }
        this.updateDocks();
    }

    public void perspectiveChangeEvent(@Observes PerspectiveChange perspectiveChange) {
        this.currentSelectedPerspective = perspectiveChange.getIdentifier();
        this.updateDocks();
        this.fireDockReadyEvent();
    }

    protected void fireDockReadyEvent() {
        this.dockReadyEvent.fire((Object)new UberfireDockReadyEvent(this.currentSelectedPerspective));
    }

    public void remove(UberfireDock ... docks) {
        for (UberfireDock dock : docks) {
            if (dock.getAssociatedPerspective() == null) continue;
            List<UberfireDock> uberfireDocks = this.docksPerPerspective.get(dock.getAssociatedPerspective());
            uberfireDocks.remove(dock);
            this.docksPerPerspective.put(dock.getAssociatedPerspective(), uberfireDocks);
        }
        this.updateDocks();
    }

    public void expand(UberfireDock dock) {
        if (this.docksBars.isReady()) {
            this.docksBars.expand(dock);
        }
    }

    public void disable(UberfireDockPosition position, String perspectiveName) {
        this.addToDisableDocksList(position, perspectiveName);
        this.disableDock(position);
    }

    private void disableDock(UberfireDockPosition position) {
        if (this.docksBars.isReady()) {
            this.docksBars.clearAndCollapse(position);
        }
    }

    public void enable(UberfireDockPosition position, String perspectiveName) {
        this.removeFromDisableDocksList(position, perspectiveName);
        this.enableDock(position);
    }

    private void enableDock(UberfireDockPosition position) {
        if (this.docksBars.isReady()) {
            List<UberfireDock> docks;
            this.docksBars.clearAndCollapse(position);
            if (this.currentSelectedPerspective != null && (docks = this.docksPerPerspective.get(this.currentSelectedPerspective)) != null && !docks.isEmpty()) {
                for (UberfireDock dock : docks) {
                    if (!dock.getDockPosition().equals((Object)position)) continue;
                    this.docksBars.addDock(dock);
                }
                this.docksBars.expand(position);
            }
        }
    }

    private void updateDocks() {
        if (this.docksBars.isReady()) {
            List<UberfireDock> docks;
            this.docksBars.clearAndCollapseAllDocks();
            if (this.currentSelectedPerspective != null && (docks = this.docksPerPerspective.get(this.currentSelectedPerspective)) != null && !docks.isEmpty()) {
                for (UberfireDock dock : docks) {
                    this.docksBars.addDock(dock);
                }
                this.expandAllAvailableDocks();
            }
        }
    }

    private void expandAllAvailableDocks() {
        for (DocksBar docksBar : this.docksBars.getDocksBars()) {
            if (!this.dockIsEnable(docksBar.getPosition())) continue;
            this.docksBars.expand(docksBar);
        }
    }

    private void addToDisableDocksList(UberfireDockPosition position, String perspectiveName) {
        Set<UberfireDockPosition> disableDocks = this.disableDocksPerPerspective.get(perspectiveName);
        if (disableDocks == null) {
            disableDocks = new HashSet<UberfireDockPosition>();
            this.disableDocksPerPerspective.put(perspectiveName, disableDocks);
        }
        disableDocks.add(position);
    }

    private void removeFromDisableDocksList(UberfireDockPosition position, String perspectiveName) {
        Set<UberfireDockPosition> disableDocks = this.disableDocksPerPerspective.get(perspectiveName);
        if (disableDocks != null) {
            disableDocks.remove(position);
        }
    }

    private boolean dockIsEnable(UberfireDockPosition dockPosition) {
        Set<UberfireDockPosition> uberfireDockPositions = this.disableDocksPerPerspective.get(this.currentSelectedPerspective);
        return uberfireDockPositions == null || !uberfireDockPositions.contains(dockPosition);
    }
}

