/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.uberfire.client.docks.view.items.SideDockItem;
import org.uberfire.client.workbench.docks.UberfireDockPosition;

public class SideDockItemFocused
extends PopupPanel {
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    Button itemButton;
    private SideDockItem parent;

    public SideDockItemFocused(SideDockItem parent) {
        super(true);
        this.parent = parent;
        this.add((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.removeStyleName("gwt-PopupPanel");
        this.createButton(parent);
    }

    void createButton(final SideDockItem parent) {
        this.itemButton.setSize(ButtonSize.SMALL);
        this.itemButton.setType(ButtonType.INFO);
        parent.configureText(this.itemButton, parent.getLabel());
        parent.configureIcon(this.itemButton, parent.getDock().getImageIconFocused());
        this.onMouseOutHidePopup();
        this.itemButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!parent.isSelected()) {
                    SideDockItemFocused.this.select();
                    parent.selectAndExecuteExpandCommand();
                } else {
                    SideDockItemFocused.this.deselect();
                    parent.deselectAndExecuteCommand();
                }
            }
        });
    }

    public void deselect() {
        this.itemButton.setActive(false);
    }

    public void select() {
        this.itemButton.setActive(true);
    }

    public void open() {
        this.setupPositionAndShow();
        if (this.parent != null) {
            this.parent.getElement().getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
    }

    private void onMouseOutHidePopup() {
        this.addDomHandler((EventHandler)new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                SideDockItemFocused.this.hide();
            }
        }, MouseOutEvent.getType());
        this.setAutoHideEnabled(true);
    }

    public void hide() {
        super.hide();
        if (this.parent != null) {
            this.parent.getElement().getStyle().setVisibility(Style.Visibility.VISIBLE);
        }
    }

    private void setupPositionAndShow() {
        this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                int left = 0;
                if (SideDockItemFocused.this.parent.getDock().getDockPosition() == UberfireDockPosition.EAST) {
                    left = Window.getClientWidth() - SideDockItemFocused.this.getOffsetWidth();
                }
                int top = SideDockItemFocused.this.parent.getAbsoluteTop();
                SideDockItemFocused.this.setPopupPosition(left, top);
            }
        });
    }

    static interface ViewBinder
    extends UiBinder<Widget, SideDockItemFocused> {
    }
}

