/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.UberfireDocksImpl;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.DocksBars;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockContainerReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.toolbar.IconType;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberfireDocksImplTest {
    @Mock
    private DocksBars docksBars;
    @Mock
    private DockLayoutPanel dockLayoutPanel;
    private UberfireDocksImpl uberfireDocks;
    private Command resizeCommand;
    private final String SOME_PERSPECTIVE = "SomePerspective";
    private final String ANOTHER_PERSPECTIVE = "AnotherPerspective";
    private UberfireDock dock0 = new UberfireDock(UberfireDockPosition.SOUTH, IconType.CHEVRON_RIGHT.name(), (PlaceRequest)new DefaultPlaceRequest("welcome"), "SomePerspective").withLabel("albel");
    private UberfireDock dock1 = new UberfireDock(UberfireDockPosition.SOUTH, IconType.AMBULANCE.name(), (PlaceRequest)new DefaultPlaceRequest("another"), "SomePerspective").withLabel("Another").withSize(200.0);
    private UberfireDock dock2 = new UberfireDock(UberfireDockPosition.EAST, IconType.ADJUST.name(), (PlaceRequest)new DefaultPlaceRequest("test"), "SomePerspective");
    private UberfireDock dock3 = new UberfireDock(UberfireDockPosition.EAST, IconType.BELL_ALT.name(), (PlaceRequest)new DefaultPlaceRequest("welcome"), "AnotherPerspective");
    private UberfireDock dock4 = new UberfireDock(UberfireDockPosition.WEST, IconType.FACETIME_VIDEO.name(), (PlaceRequest)new DefaultPlaceRequest("welcome"), "AnotherPerspective").withLabel("Welcome").withSize(200.0);

    @Before
    public void setup() {
        this.uberfireDocks = new UberfireDocksImpl(this.docksBars){

            protected void fireDockReadyEvent() {
            }
        };
        this.resizeCommand = () -> {};
    }

    @Test
    public void setupDocks() {
        this.uberfireDocks.setup(new UberfireDockContainerReadyEvent());
        ((DocksBars)Mockito.verify((Object)this.docksBars)).setup();
    }

    @Test
    public void configure() {
        HashMap<String, String> configurations = new HashMap<String, String>();
        configurations.put("IDE_DOCK", "true");
        this.uberfireDocks.configure(configurations);
        ((DocksBars)Mockito.verify((Object)this.docksBars)).setIDEdock(Boolean.valueOf(true));
    }

    @Test
    public void add() {
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1, this.dock2, this.dock3, this.dock4});
        List docksSomePerspective = (List)this.uberfireDocks.docksPerPerspective.get("SomePerspective");
        List docksAnotherPerspective = (List)this.uberfireDocks.docksPerPerspective.get("AnotherPerspective");
        Assert.assertEquals((long)3L, (long)docksSomePerspective.size());
        Assert.assertEquals((long)2L, (long)docksAnotherPerspective.size());
    }

    @Test
    public void perspectiveChangeEvent() {
        Mockito.when((Object)this.docksBars.isReady()).thenReturn((Object)true);
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.perspectiveChangeEvent(new PerspectiveChange(null, null, null, "SomePerspective"));
        Assert.assertEquals((Object)"SomePerspective", (Object)this.uberfireDocks.currentSelectedPerspective);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.times((int)2))).clearAndCollapseAllDocks();
        ((DocksBars)Mockito.verify((Object)this.docksBars)).addDock(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars)).addDock(this.dock1);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.times((int)docksBars.size()))).expand((DocksBar)Matchers.any(DocksBar.class));
    }

    @Test
    public void remove() {
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        Mockito.when((Object)this.docksBars.isReady()).thenReturn((Object)true);
        this.uberfireDocks.currentSelectedPerspective = "SomePerspective";
        this.uberfireDocks.remove(new UberfireDock[]{this.dock0});
        ((DocksBars)Mockito.verify((Object)this.docksBars)).clearAndCollapseAllDocks();
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.never())).addDock(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars)).addDock(this.dock1);
    }

    @Test
    public void disableDock() {
        Mockito.when((Object)this.docksBars.isReady()).thenReturn((Object)true);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.currentSelectedPerspective = "SomePerspective";
        Mockito.when((Object)this.docksBars.isReady()).thenReturn((Object)true);
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.disable(UberfireDockPosition.WEST, "SomePerspective");
        ((DocksBars)Mockito.verify((Object)this.docksBars)).clearAndCollapse(UberfireDockPosition.WEST);
    }

    @Test
    public void enableDock() {
        Mockito.when((Object)this.docksBars.isReady()).thenReturn((Object)true);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.currentSelectedPerspective = "SomePerspective";
        Mockito.when((Object)this.docksBars.isReady()).thenReturn((Object)true);
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.disable(UberfireDockPosition.WEST, "SomePerspective");
        this.uberfireDocks.enable(UberfireDockPosition.WEST, "SomePerspective");
        ((DocksBars)Mockito.verify((Object)this.docksBars)).expand(UberfireDockPosition.WEST);
    }

    private List<DocksBar> generateDocksBars() {
        ArrayList<DocksBar> docksBar = new ArrayList<DocksBar>();
        docksBar.add(this.createDocksBar(UberfireDockPosition.WEST));
        docksBar.add(this.createDocksBar(UberfireDockPosition.EAST));
        docksBar.add(this.createDocksBar(UberfireDockPosition.SOUTH));
        return docksBar;
    }

    private DocksBar createDocksBar(UberfireDockPosition west) {
        return new DocksBar(west){

            protected void setupChildBars(UberfireDockPosition position) {
            }

            public boolean equals(Object obj) {
                DocksBar obj1 = (DocksBar)obj;
                return this.getPosition().equals((Object)obj1.getPosition());
            }
        };
    }
}

