/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.uberfire.client.docks.view.items.AbstractDockItem;
import org.uberfire.client.docks.view.items.SideDockItemFocused;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.mvp.ParameterizedCommand;

public class SideDockItem
extends AbstractDockItem {
    private MouseEventHandler mouseEventHandler;
    @UiField
    Button itemButton;
    private final ParameterizedCommand<String> selectCommand;
    private final ParameterizedCommand<String> deselectCommand;
    private SideDockItemFocused popup = new SideDockItemFocused(this);
    private boolean selected;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);

    SideDockItem(UberfireDock dock, ParameterizedCommand<String> selectCommand, ParameterizedCommand<String> deselectCommand) {
        super(dock);
        this.selectCommand = selectCommand;
        this.deselectCommand = deselectCommand;
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.createButton();
    }

    void createButton() {
        this.itemButton.setSize(ButtonSize.SMALL);
        this.itemButton.setType(ButtonType.LINK);
        this.configureIcon(this.itemButton, this.getDock().getImageIcon());
        this.mouseEventHandler = new MouseEventHandler();
        this.itemButton.addDomHandler((EventHandler)this.mouseEventHandler, MouseOverEvent.getType());
        this.itemButton.addStyleName(CSS.CSS().sideDockItem());
        this.itemButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!SideDockItem.this.isSelected()) {
                    SideDockItem.this.selectAndExecuteExpandCommand();
                } else {
                    SideDockItem.this.deselectAndExecuteCommand();
                }
            }
        });
    }

    @Override
    public void select() {
        this.selected = true;
        this.itemButton.setActive(true);
        this.itemButton.setType(ButtonType.INFO);
        if (this.getDock().getImageIconFocused() != null) {
            this.itemButton.remove(0);
            this.configureImageIcon(this.itemButton, this.getDock().getImageIconFocused());
        }
    }

    @Override
    public void selectAndExecuteExpandCommand() {
        this.select();
        this.popup.select();
        this.selectCommand.execute((Object)this.getIdentifier());
    }

    @Override
    public void deselect() {
        this.selected = false;
        this.popup.deselect();
        this.itemButton.setActive(false);
        this.itemButton.setType(ButtonType.LINK);
        if (this.getDock().getImageIcon() != null) {
            this.itemButton.remove(0);
            this.configureImageIcon(this.itemButton, this.getDock().getImageIcon());
        }
    }

    public void deselectAndExecuteCommand() {
        this.deselect();
        this.deselectCommand.execute((Object)this.getIdentifier());
    }

    private boolean openPopup() {
        return !this.isSelected();
    }

    public boolean isSelected() {
        return this.selected;
    }

    SideDockItemFocused getPopup() {
        return this.popup;
    }

    class MouseEventHandler
    implements MouseOverHandler {
        public void onMouseOver(MouseOverEvent moe) {
            if (SideDockItem.this.openPopup()) {
                SideDockItem.this.popup.open();
            }
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, SideDockItem> {
    }
}

