/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.DocksBars;
import org.uberfire.client.docks.view.bars.DocksCollapsedBar;
import org.uberfire.client.docks.view.menu.MenuBuilder;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocksContainer;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.toolbar.IconType;

@RunWith(value=GwtMockitoTestRunner.class)
public class DocksBarsTest {
    private final String SOME_PERSPECTIVE = "SomePerspective";
    @Mock
    private UberfireDocksContainer uberfireDocksContainer;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private MenuBuilder menuBuilder;
    @Mock
    private EventSourceMock<UberfireDocksInteractionEvent> dockInteractionEvent;
    private DocksBars docksBars;
    private UberfireDock dock0 = new UberfireDock(UberfireDockPosition.SOUTH, IconType.CHEVRON_RIGHT.name(), (PlaceRequest)new DefaultPlaceRequest("welcome"), "SomePerspective").withLabel("label");

    @Before
    public void setup() {
        this.docksBars = new DocksBars(this.placeManager, this.menuBuilder, this.dockInteractionEvent, this.uberfireDocksContainer, null);
    }

    @Test
    public void setupDocks() {
        this.docksBars.setup();
        Assert.assertEquals((long)3L, (long)this.docksBars.getDocksBars().size());
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer, (VerificationMode)Mockito.times((int)3))).add((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.EAST), (Widget)Matchers.any(Widget.class), (Double)Matchers.any(Double.class));
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer, (VerificationMode)Mockito.times((int)3))).add((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.WEST), (Widget)Matchers.any(Widget.class), (Double)Matchers.any(Double.class));
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer, (VerificationMode)Mockito.times((int)3))).add((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.SOUTH), (Widget)Matchers.any(Widget.class), (Double)Matchers.any(Double.class));
    }

    @Test
    public void addDock() {
        this.docksBars.setup();
        DocksBar dockBar = this.docksBars.getDockBar(this.dock0);
        DocksBar targetDockSpy = (DocksBar)Mockito.spy((Object)dockBar);
        DocksBars dockBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        Mockito.when((Object)dockBarsSpy.getDockBar(this.dock0)).thenReturn((Object)targetDockSpy);
        dockBarsSpy.addDock(this.dock0);
        ((DocksBar)Mockito.verify((Object)targetDockSpy)).addDock((UberfireDock)Matchers.eq((Object)this.dock0), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void getDockBar() {
        this.docksBars.setup();
        DocksBar targetDockBar = this.docksBars.getDockBar(this.dock0);
        Assert.assertEquals((Object)this.dock0.getDockPosition(), (Object)targetDockBar.getPosition());
    }

    @Test
    public void clearAndCollapseAllDocks() {
        this.docksBars.setup();
        DocksBars docksBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        ArrayList<DocksBar> dockBars = new ArrayList<DocksBar>();
        DocksBar dock1 = this.createDocksBarMock();
        dockBars.add(dock1);
        DocksBar dock2 = this.createDocksBarMock();
        dockBars.add(dock2);
        Mockito.when((Object)docksBarsSpy.getDocksBars()).thenReturn(dockBars);
        docksBarsSpy.clearAndCollapseAllDocks();
        ((DocksBar)Mockito.verify((Object)dock1)).clearAll();
        ((DocksBar)Mockito.verify((Object)dock2)).clearAll();
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer, (VerificationMode)Mockito.times((int)6))).hide((Widget)Matchers.any(Widget.class));
    }

    @Test
    public void clearAndCollapse() {
        this.docksBars.setup();
        DocksBars docksBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        DocksBar dock1 = this.createDocksBarMock();
        Mockito.when((Object)docksBarsSpy.getDockBar(UberfireDockPosition.EAST)).thenReturn((Object)dock1);
        docksBarsSpy.clearAndCollapse(UberfireDockPosition.EAST);
        ((DocksBar)Mockito.verify((Object)dock1)).clearAll();
        ((DocksBars)Mockito.verify((Object)docksBarsSpy)).resizeDeferred();
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer, (VerificationMode)Mockito.times((int)3))).hide((Widget)Matchers.any(Widget.class));
    }

    @Test
    public void expand() {
        this.docksBars.setup();
        this.docksBars.addDock(this.dock0);
        this.docksBars.expand(this.docksBars.getDockBar(this.dock0));
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer, (VerificationMode)Mockito.times((int)1))).show((Widget)Matchers.any(Widget.class));
    }

    @Test
    public void dockSelectCommand() {
        DocksBars docksBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        docksBarsSpy.setup();
        docksBarsSpy.addDock(this.dock0);
        ((DocksBars)Mockito.doNothing().when((Object)docksBarsSpy)).selectDock(this.dock0, this.docksBars.getDockBar(this.dock0));
        ParameterizedCommand dockSelectCommand = docksBarsSpy.createDockSelectCommand(this.dock0, this.docksBars.getDockBar(this.dock0));
        dockSelectCommand.execute((Object)this.dock0.getIdentifier());
        ((DocksBars)Mockito.verify((Object)docksBarsSpy)).selectDock(this.dock0, this.docksBars.getDockBar(this.dock0));
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer)).resize();
        ((EventSourceMock)Mockito.verify(this.dockInteractionEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new UberfireDocksInteractionEvent(this.dock0, UberfireDocksInteractionEvent.InteractionType.SELECTED));
    }

    @Test
    public void dockSelectCommandSingleMode() {
        DocksBars docksBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        docksBarsSpy.setup();
        docksBarsSpy.addDock(this.dock0);
        DocksBar dockBar = (DocksBar)Mockito.spy((Object)this.docksBars.getDockBar(this.dock0));
        ((DocksBars)Mockito.doNothing().when((Object)docksBarsSpy)).selectDock(this.dock0, dockBar);
        Mockito.when((Object)dockBar.isCollapsedBarInSingleMode()).thenReturn((Object)true);
        ParameterizedCommand dockSelectCommand = docksBarsSpy.createDockSelectCommand(this.dock0, dockBar);
        dockSelectCommand.execute((Object)this.dock0.getIdentifier());
        ((DocksBars)Mockito.verify((Object)docksBarsSpy)).selectDock(this.dock0, dockBar);
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer)).resize();
        ((DocksBars)Mockito.verify((Object)docksBarsSpy)).collapse((Widget)dockBar.getCollapsedBar());
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer, (VerificationMode)Mockito.times((int)1))).hide((Widget)Matchers.any(Widget.class));
        ((EventSourceMock)Mockito.verify(this.dockInteractionEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new UberfireDocksInteractionEvent(this.dock0, UberfireDocksInteractionEvent.InteractionType.SELECTED));
    }

    @Test
    public void dockDeSelectCommand() {
        DocksBars spy = (DocksBars)Mockito.spy((Object)this.docksBars);
        spy.setup();
        spy.addDock(this.dock0);
        ((DocksBars)Mockito.doNothing().when((Object)spy)).deselectDock(this.docksBars.getDockBar(this.dock0));
        ParameterizedCommand dockSelectCommand = spy.createDockDeselectCommand(this.dock0, this.docksBars.getDockBar(this.dock0));
        dockSelectCommand.execute((Object)this.dock0.getIdentifier());
        ((DocksBars)Mockito.verify((Object)spy)).deselectDock(this.docksBars.getDockBar(this.dock0));
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer)).resize();
        ((EventSourceMock)Mockito.verify(this.dockInteractionEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new UberfireDocksInteractionEvent(this.dock0, UberfireDocksInteractionEvent.InteractionType.DESELECTED));
    }

    @Test
    public void dockDeSelectCommandSingleMode() {
        DocksBars docksBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        docksBarsSpy.setup();
        docksBarsSpy.addDock(this.dock0);
        DocksBar dockBar = (DocksBar)Mockito.spy((Object)this.docksBars.getDockBar(this.dock0));
        ((DocksBars)Mockito.doNothing().when((Object)docksBarsSpy)).deselectDock(dockBar);
        Mockito.when((Object)dockBar.isCollapsedBarInSingleMode()).thenReturn((Object)true);
        ParameterizedCommand dockSelectCommand = docksBarsSpy.createDockDeselectCommand(this.dock0, dockBar);
        dockSelectCommand.execute((Object)this.dock0.getIdentifier());
        ((DocksBars)Mockito.verify((Object)docksBarsSpy)).deselectDock(dockBar);
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer)).resize();
        ((DocksBars)Mockito.verify((Object)docksBarsSpy)).expand((Widget)dockBar.getCollapsedBar());
        ((EventSourceMock)Mockito.verify(this.dockInteractionEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new UberfireDocksInteractionEvent(this.dock0, UberfireDocksInteractionEvent.InteractionType.DESELECTED));
    }

    @Test
    public void dockResizeCommand() {
        double simulatedSize = 0.0;
        DocksBars docksBarsSpy = (DocksBars)Mockito.spy((Object)this.docksBars);
        docksBarsSpy.setup();
        docksBarsSpy.addDock(this.dock0);
        ((DocksBars)Mockito.doReturn((Object)true).when((Object)docksBarsSpy)).sizeIsValid((Double)Matchers.any(Double.class), (DocksBar)Matchers.any(DocksBar.class));
        DocksBar dockBar = (DocksBar)Mockito.spy((Object)this.docksBars.getDockBar(this.dock0));
        ParameterizedCommand dockResizeCommand = docksBarsSpy.createResizeCommand(dockBar);
        dockResizeCommand.execute((Object)0.0);
        ((DocksBar)Mockito.verify((Object)dockBar)).setExpandedSize(Double.valueOf(0.0));
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer)).resize();
        ((EventSourceMock)Mockito.verify(this.dockInteractionEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new UberfireDocksInteractionEvent(UberfireDockPosition.SOUTH, UberfireDocksInteractionEvent.InteractionType.RESIZED));
    }

    private DocksBar createDocksBarMock() {
        DocksBar mock = (DocksBar)Mockito.mock(DocksBar.class);
        Mockito.when((Object)mock.getCollapsedBar()).thenReturn(Mockito.mock(DocksCollapsedBar.class));
        return mock;
    }
}

