/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.bars;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.client.docks.view.items.AbstractDockItem;
import org.uberfire.client.docks.view.items.SingleSideDockItem;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.util.CSSLocatorsUtils;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;

public class DocksCollapsedBar
extends Composite {
    @UiField
    FlowPanel docksBarPanel;
    private UberfireDockPosition position;
    private WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    private AbstractDockItem firstDockItem;
    private SingleSideDockItem singleSideDockItem;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private List<AbstractDockItem> docksItems = new ArrayList<AbstractDockItem>();

    public DocksCollapsedBar(UberfireDockPosition position) {
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.position = position;
        this.setCSS(position);
    }

    private void setCSS(UberfireDockPosition position) {
        if (position == UberfireDockPosition.SOUTH) {
            this.docksBarPanel.addStyleName(this.CSS.CSS().gradientTopBottom());
        } else {
            this.docksBarPanel.addStyleName(this.CSS.CSS().gradientBottomTop());
        }
        this.setupCSSLocators(position);
    }

    private void setupCSSLocators(UberfireDockPosition position) {
        this.docksBarPanel.addStyleName(CSSLocatorsUtils.buildLocator((String[])new String[]{"qe-docks-bar", position.getShortName()}));
    }

    public void addDock(UberfireDock dock, ParameterizedCommand<String> selectCommand, ParameterizedCommand<String> deselectCommand) {
        AbstractDockItem dockItem = AbstractDockItem.create(dock, selectCommand, deselectCommand);
        if (dock.getDockPosition().allowSingleDockItem()) {
            this.handleSingleDockItem(dockItem, dock, selectCommand, deselectCommand);
        }
        this.docksBarPanel.add((Widget)dockItem);
        this.docksItems.add(dockItem);
    }

    private void handleSingleDockItem(AbstractDockItem dockItem, UberfireDock dock, ParameterizedCommand<String> selectCommand, ParameterizedCommand<String> deselectCommand) {
        if (this.docksItems.isEmpty()) {
            this.createSingleDockItem(dockItem, dock, selectCommand, deselectCommand);
        } else if (this.singleDockMode()) {
            this.clearSingleDockItem();
        }
    }

    public boolean singleDockMode() {
        return this.position.allowSingleDockItem() && this.docksItems.size() == 1;
    }

    private void createSingleDockItem(AbstractDockItem dockItem, UberfireDock dock, ParameterizedCommand<String> selectCommand, ParameterizedCommand<String> deselectCommand) {
        this.firstDockItem = dockItem;
        this.firstDockItem.addStyleName(this.CSS.CSS().hideElement());
        this.singleSideDockItem = new SingleSideDockItem(dock, selectCommand, deselectCommand);
        this.docksBarPanel.add((Widget)this.singleSideDockItem);
    }

    private void clearSingleDockItem() {
        this.firstDockItem.removeStyleName(this.CSS.CSS().hideElement());
        this.docksBarPanel.remove((Widget)this.singleSideDockItem);
    }

    public void setupDnD() {
        this.createDropHandler();
        for (AbstractDockItem docksItem : this.docksItems) {
            docksItem.setupDnD();
        }
    }

    private void createDropHandler() {
    }

    public void clear() {
        this.docksBarPanel.clear();
        this.docksItems = new ArrayList<AbstractDockItem>();
    }

    public void setDockSelected(UberfireDock dockSelected) {
        for (AbstractDockItem docksItem : this.docksItems) {
            if (docksItem.getDock().equals((Object)dockSelected)) {
                docksItem.select();
                continue;
            }
            docksItem.deselect();
        }
    }

    public void deselectAllDocks() {
        for (AbstractDockItem docksItem : this.docksItems) {
            docksItem.deselect();
        }
    }

    public UberfireDockPosition getPosition() {
        return this.position;
    }

    public List<AbstractDockItem> getDocksItems() {
        return this.docksItems;
    }

    public void expand(UberfireDock targetDock) {
        for (AbstractDockItem abstractDockItem : this.getDocksItems()) {
            UberfireDock candidate = abstractDockItem.getDock();
            if (!candidate.equals((Object)targetDock)) continue;
            abstractDockItem.selectAndExecuteExpandCommand();
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, DocksCollapsedBar> {
    }
}

