/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Element;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.view.items.SideDockItem;
import org.uberfire.client.docks.view.items.SideDockItemFocused;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class SideDockItemFocusedTest {
    private SideDockItemFocused focusedItem;
    @Mock
    private SideDockItem sideDockItem;
    @Mock
    private UberfireDock uberfireDock;
    @GwtMock
    private Button button;
    private ClickHandler clickHandler;
    private Element element;
    private Style style;

    @Before
    public void setUp() {
        Mockito.when((Object)this.uberfireDock.getDockPosition()).thenReturn((Object)UberfireDockPosition.EAST);
        Mockito.when((Object)this.uberfireDock.getIconType()).thenReturn((Object)"RANDOM");
        Mockito.when((Object)this.uberfireDock.getPlaceRequest()).thenReturn(Mockito.mock(PlaceRequest.class));
        Mockito.when((Object)this.sideDockItem.getDock()).thenReturn((Object)this.uberfireDock);
        this.focusedItem = (SideDockItemFocused)Mockito.spy((Object)new SideDockItemFocused(this.sideDockItem));
        Mockito.when((Object)this.button.addClickHandler((ClickHandler)Matchers.any(ClickHandler.class))).thenAnswer(aInvocation -> {
            this.clickHandler = (ClickHandler)aInvocation.getArguments()[0];
            return null;
        });
        this.element = (Element)Mockito.mock(Element.class);
        this.style = (Style)Mockito.mock(Style.class);
        Mockito.when((Object)this.sideDockItem.getElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getStyle()).thenReturn((Object)this.style);
    }

    @Test
    public void createTest() {
        ((Button)Mockito.verify((Object)this.button)).setSize(ButtonSize.SMALL);
        ((Button)Mockito.verify((Object)this.button)).setType(ButtonType.INFO);
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem)).configureText((Button)Matchers.any(Button.class), (String)Mockito.eq((Object)null));
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem)).configureIcon((Button)Matchers.any(Button.class), (ImageResource)Mockito.eq((Object)null));
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem, (VerificationMode)Mockito.never())).configureImageIcon((Button)Matchers.any(Button.class), (ImageResource)Matchers.any(ImageResource.class));
    }

    @Test
    public void createWithClosedSideDockTest() {
        Mockito.when((Object)this.sideDockItem.isOpened()).thenReturn((Object)false);
        this.focusedItem.createButton(this.sideDockItem);
        this.clickHandler.onClick(new ClickEvent(){});
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem)).openAndExecuteExpandCommand();
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem, (VerificationMode)Mockito.never())).closeAndExecuteCommand();
        ((Button)Mockito.verify((Object)this.button)).setActive(false);
        ((Button)Mockito.verify((Object)this.button, (VerificationMode)Mockito.never())).setActive(true);
    }

    @Test
    public void createWithOpenedSideDockTest() {
        Mockito.when((Object)this.sideDockItem.isOpened()).thenReturn((Object)true);
        this.focusedItem.createButton(this.sideDockItem);
        this.clickHandler.onClick(new ClickEvent(){});
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem)).closeAndExecuteCommand();
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem, (VerificationMode)Mockito.never())).openAndExecuteExpandCommand();
        ((Button)Mockito.verify((Object)this.button)).setActive(true);
        ((Button)Mockito.verify((Object)this.button, (VerificationMode)Mockito.never())).setActive(false);
    }

    @Test
    public void openTest() {
        this.focusedItem.open();
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem)).getElement();
        ((Element)Mockito.verify((Object)this.element)).getStyle();
        ((Style)Mockito.verify((Object)this.style)).setVisibility(Style.Visibility.HIDDEN);
        ((Style)Mockito.verify((Object)this.style, (VerificationMode)Mockito.never())).setVisibility(Style.Visibility.VISIBLE);
    }

    @Test
    public void hideTest() {
        this.focusedItem.hide();
        ((SideDockItem)Mockito.verify((Object)this.sideDockItem)).getElement();
        ((Element)Mockito.verify((Object)this.element)).getStyle();
        ((Style)Mockito.verify((Object)this.style)).setVisibility(Style.Visibility.VISIBLE);
        ((Style)Mockito.verify((Object)this.style, (VerificationMode)Mockito.never())).setVisibility(Style.Visibility.HIDDEN);
    }
}

