/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.bars;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.view.bars.DocksExpandedBar;
import org.uberfire.client.workbench.docks.UberfireDockPosition;

@RunWith(value=GwtMockitoTestRunner.class)
public class DocksExpandedBarTest {
    private DocksExpandedBar docksExpandedBar;
    private FlowPanel targetPanel;

    @Before
    public void setup() {
        DocksExpandedBar dock = new DocksExpandedBar(UberfireDockPosition.WEST);
        dock.targetPanel = this.targetPanel = (FlowPanel)Mockito.mock(FlowPanel.class);
        this.docksExpandedBar = (DocksExpandedBar)Mockito.spy((Object)dock);
    }

    @Test
    public void resizeTest() {
        this.docksExpandedBar.onResize();
        ((DocksExpandedBar)Mockito.verify((Object)this.docksExpandedBar)).resizeTargetPanel();
    }

    @Test
    public void resizeWithAnInvalidWidthShouldNeverSetupSizeOfTargetPanel() {
        ((DocksExpandedBar)Mockito.doReturn((Object)0).when((Object)this.docksExpandedBar)).calculateDockHeight();
        ((DocksExpandedBar)Mockito.doReturn((Object)0).when((Object)this.docksExpandedBar)).calculateDockWidth();
        this.docksExpandedBar.onResize();
        ((FlowPanel)Mockito.verify((Object)this.targetPanel, (VerificationMode)Mockito.never())).setPixelSize(Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void resizeWithAValidWidthShouldNeverSetupSizeOfTargetPanel() {
        ((DocksExpandedBar)Mockito.doReturn((Object)10).when((Object)this.docksExpandedBar)).calculateDockHeight();
        ((DocksExpandedBar)Mockito.doReturn((Object)110).when((Object)this.docksExpandedBar)).calculateDockWidth();
        this.docksExpandedBar.onResize();
        ((FlowPanel)Mockito.verify((Object)this.targetPanel, (VerificationMode)Mockito.never())).setPixelSize(10, 110);
    }

    @Test
    public void setPanelSizeWithAnInvalidWidthShouldNeverSetupSizeOfTargetPanel() {
        this.docksExpandedBar.setPanelSize(0, -1);
        ((FlowPanel)Mockito.verify((Object)this.targetPanel, (VerificationMode)Mockito.never())).setPixelSize(Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void setPanelSizeAValidWidthShouldNeverSetupSizeOfTargetPanel() {
        this.docksExpandedBar.setPanelSize(1, 10);
        ((FlowPanel)Mockito.verify((Object)this.targetPanel)).setPixelSize(1, 10);
    }
}

