/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.view.items.SideDockItem;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class SideDockItemTest {
    @Mock
    private ImageResource imageResource;
    @Mock
    private ImageResource imageResourceFocused;
    @Mock
    private PlaceRequest placeRequest;
    private ParameterizedCommand<String> emptyCommand;
    private UberfireDock dockWithFontIcon;
    private UberfireDock dockWithImageIcon;
    private SideDockItem sideDockWithFontIcon;
    private SideDockItem sideDockWithImageIcon;

    @Before
    public void setup() {
        this.dockWithFontIcon = new UberfireDock(UberfireDockPosition.EAST, "BRIEFCASE", this.placeRequest, "").withSize(450.0).withLabel("dock");
        this.dockWithImageIcon = new UberfireDock(UberfireDockPosition.EAST, this.imageResource, this.imageResourceFocused, this.placeRequest, "").withSize(450.0).withLabel("dock");
        this.sideDockWithFontIcon = (SideDockItem)Mockito.spy((Object)new SideDockItem(this.dockWithFontIcon, this.emptyCommand, this.emptyCommand));
        this.sideDockWithImageIcon = (SideDockItem)Mockito.spy((Object)new SideDockItem(this.dockWithImageIcon, this.emptyCommand, this.emptyCommand));
        this.emptyCommand = parameter -> {};
    }

    @Test
    public void createSideDockItemWithFontIconTest() {
        this.sideDockWithFontIcon.createButton();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon)).configureIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)null));
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void openSideDockItemWithFontIconTest() {
        this.sideDockWithFontIcon.open();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void closeSideDockItemWithFontIconTest() {
        this.sideDockWithFontIcon.close();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void createSideDockItemWithImageIconTest() {
        this.sideDockWithImageIcon.createButton();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
    }

    @Test
    public void openSouthDockItemWithImageIconTest() {
        this.sideDockWithImageIcon.open();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResourceFocused));
    }

    @Test
    public void closeSouthDockItemWithImageIconTest() {
        this.sideDockWithImageIcon.close();
        ((SideDockItem)Mockito.verify((Object)this.sideDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
    }

    @Test
    public void createSideDockItemWithTooltipTest() {
        String dock_screenID = "SCREEN_ID";
        String dock_label = "DOCK TITLE";
        String dock_tooltip = "DOCK TOOLTIP";
        UberfireDock dock1 = new UberfireDock(UberfireDockPosition.EAST, "BRIEFCASE", this.placeRequest, "").withLabel("DOCK TITLE").withTooltip("DOCK TOOLTIP");
        SideDockItem tested1 = (SideDockItem)Mockito.spy((Object)new SideDockItem(dock1, this.emptyCommand, this.emptyCommand));
        tested1.createButton();
        ((SideDockItem)Mockito.verify((Object)tested1)).configureTooltip((Tooltip)Mockito.any(Tooltip.class), (String)Mockito.eq((Object)"DOCK TOOLTIP"));
        UberfireDock dock2 = new UberfireDock(UberfireDockPosition.EAST, "BRIEFCASE", this.placeRequest, "").withLabel("DOCK TITLE");
        SideDockItem tested2 = (SideDockItem)Mockito.spy((Object)new SideDockItem(dock2, this.emptyCommand, this.emptyCommand));
        tested2.createButton();
        ((SideDockItem)Mockito.verify((Object)tested2)).configureTooltip((Tooltip)Mockito.any(Tooltip.class), (String)Mockito.eq((Object)"DOCK TITLE"));
        UberfireDock dock3 = new UberfireDock(UberfireDockPosition.EAST, "BRIEFCASE", (PlaceRequest)new DefaultPlaceRequest("SCREEN_ID"), "");
        SideDockItem tested3 = (SideDockItem)Mockito.spy((Object)new SideDockItem(dock3, this.emptyCommand, this.emptyCommand));
        tested3.createButton();
        ((SideDockItem)Mockito.verify((Object)tested3)).configureTooltip((Tooltip)Mockito.any(Tooltip.class), (String)Mockito.eq((Object)"SCREEN_ID"));
        Tooltip tooltip = new Tooltip();
        this.sideDockWithImageIcon.configureTooltip(tooltip, this.sideDockWithImageIcon.getLabel());
        Assert.assertEquals((Object)this.sideDockWithImageIcon.getLabel(), (Object)tooltip.getTitle());
        Assert.assertEquals((Object)Placement.LEFT, (Object)tooltip.getPlacement());
    }
}

