/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.uberfire.client.docks.view.items.AbstractSideDockItem;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.mvp.ParameterizedCommand;

public class SideDockItem
extends AbstractSideDockItem {
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    private final ParameterizedCommand<String> openCommand;
    private final ParameterizedCommand<String> closeCommand;
    @UiField
    Button itemButton;
    @UiField
    Tooltip itemTooltip;
    private boolean opened;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);

    SideDockItem(UberfireDock dock, ParameterizedCommand<String> openCommand, ParameterizedCommand<String> closeCommand) {
        super(dock);
        this.openCommand = openCommand;
        this.closeCommand = closeCommand;
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.createButton();
        this.setupCSSLocators(dock);
    }

    void createButton() {
        this.itemButton.setSize(ButtonSize.SMALL);
        this.itemButton.setType(ButtonType.LINK);
        this.configureIcon(this.itemButton, this.getDock().getImageIcon());
        String tooltip = this.getDock().getTooltip();
        if (tooltip == null) {
            tooltip = this.getDock().getLabel();
        }
        this.configureTooltip(this.itemTooltip, tooltip);
        this.itemButton.addStyleName(CSS.CSS().sideDockItem());
        this.itemButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!SideDockItem.this.isOpened()) {
                    SideDockItem.this.openAndExecuteExpandCommand();
                } else {
                    SideDockItem.this.closeAndExecuteCommand();
                }
            }
        });
    }

    @Override
    public void open() {
        this.opened = true;
        this.itemButton.setActive(true);
        this.itemButton.setType(ButtonType.INFO);
        if (this.getDock().getImageIconFocused() != null) {
            this.itemButton.remove(0);
            this.configureImageIcon(this.itemButton, this.getDock().getImageIconFocused());
        }
    }

    @Override
    public void openAndExecuteExpandCommand() {
        this.open();
        this.openCommand.execute((Object)this.getIdentifier());
    }

    @Override
    public void close() {
        this.opened = false;
        this.itemButton.setActive(false);
        this.itemButton.setType(ButtonType.LINK);
        if (this.getDock().getImageIcon() != null) {
            this.itemButton.remove(0);
            this.configureImageIcon(this.itemButton, this.getDock().getImageIcon());
        }
    }

    public void closeAndExecuteCommand() {
        this.close();
        this.closeCommand.execute((Object)this.getIdentifier());
    }

    public boolean isOpened() {
        return this.opened;
    }

    static interface ViewBinder
    extends UiBinder<Widget, SideDockItem> {
    }
}

