/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view;

import org.uberfire.client.docks.view.DockResizeBar;
import org.uberfire.client.docks.view.bars.DocksCollapsedBar;
import org.uberfire.client.docks.view.bars.DocksExpandedBar;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

public class DocksBar {
    private UberfireDockPosition position;
    private DocksCollapsedBar collapsedBar;
    private Double collapsedDefaultSize = 35.0;
    private DocksExpandedBar expandedBar;
    private Double expandedDefaultSize;
    private Double expandedSize = this.expandedDefaultSize = Double.valueOf(150.0);
    private DockResizeBar dockResizeBar;
    private Double dockResizeBarDefaultSize = 2.0;
    private UberfireDock openDock;

    public DocksBar(UberfireDockPosition position) {
        this.position = position;
        this.setupChildBars(position);
    }

    protected void setupChildBars(UberfireDockPosition position) {
        this.collapsedBar = new DocksCollapsedBar(position);
        this.expandedBar = new DocksExpandedBar(position);
        this.dockResizeBar = new DockResizeBar(this);
    }

    public DocksCollapsedBar getCollapsedBar() {
        return this.collapsedBar;
    }

    public boolean isCollapsedBarInSingleMode() {
        return this.collapsedBar.singleDockMode();
    }

    public DocksExpandedBar getExpandedBar() {
        return this.expandedBar;
    }

    public Double getCollapsedBarSize() {
        return this.collapsedDefaultSize;
    }

    public double getExpandedBarSize() {
        return this.expandedSize;
    }

    public void setExpandedSize(Double expandedSize) {
        this.expandedSize = expandedSize;
    }

    public void clearAll() {
        this.collapsedBar.clear();
        this.expandedBar.clear();
    }

    public void addDock(UberfireDock dock, ParameterizedCommand<String> openCommand, ParameterizedCommand<String> closeCommand) {
        if (this.collapsedBar != null) {
            this.collapsedBar.addDock(dock, openCommand, closeCommand);
        }
    }

    public UberfireDockPosition getPosition() {
        return this.position;
    }

    public boolean hasDocksItems() {
        return !this.collapsedBar.getDocksItems().isEmpty();
    }

    public DockResizeBar getDockResizeBar() {
        return this.dockResizeBar;
    }

    public Double getDockResizeBarDefaultSize() {
        return this.dockResizeBarDefaultSize;
    }

    public void configureResizeBar(ParameterizedCommand<Double> resizeCommand) {
        this.dockResizeBar.setup(resizeCommand);
    }

    public void open(UberfireDock dock) {
        if (this.hasDocksItems()) {
            this.collapsedBar.expand(dock);
        }
    }

    public void setOpenDock(UberfireDock openDock) {
        this.openDock = openDock;
    }

    public boolean isOpen() {
        return this.openDock != null;
    }

    public boolean isOpenWith(PlaceRequest placeRequest) {
        return this.isOpen() && this.openDock.getPlaceRequest().equals(placeRequest);
    }

    public void clearExpandedDock(UberfireDock expandedDock) {
        if (this.openDock != null && this.openDock.getPlaceRequest().equals(expandedDock.getPlaceRequest())) {
            this.openDock = null;
        }
    }
}

