/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.NavbarLink;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;

@ApplicationScoped
public class MenuBuilder {
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;

    public Widget makeItem(MenuItem item, boolean isRoot) {
        Object result;
        if (!this.authzManager.authorize((Resource)item, this.identity)) {
            return null;
        }
        if (item instanceof MenuItemCommand) {
            final MenuItemCommand cmdItem = (MenuItemCommand)item;
            if (isRoot) {
                final Button button = new Button(cmdItem.getCaption());
                button.setSize(ButtonSize.SMALL);
                button.setEnabled(item.isEnabled());
                button.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        cmdItem.getCommand().execute();
                    }
                });
                item.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                    public void enabledStateChanged(boolean enabled) {
                        button.setEnabled(enabled);
                    }
                });
                return button;
            }
            final NavbarLink navbarLink = new NavbarLink();
            navbarLink.setText(cmdItem.getCaption());
            if (!item.isEnabled()) {
                navbarLink.addStyleName("disabled");
            }
            navbarLink.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    cmdItem.getCommand().execute();
                }
            });
            item.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                public void enabledStateChanged(boolean enabled) {
                    if (enabled) {
                        navbarLink.removeStyleName("disabled");
                    } else {
                        navbarLink.addStyleName("disabled");
                    }
                }
            });
            return navbarLink;
        }
        if (item instanceof MenuGroup) {
            MenuGroup groups = (MenuGroup)item;
            if (isRoot) {
                ArrayList<Widget> widgetList = new ArrayList<Widget>();
                for (MenuItem _item : groups.getItems()) {
                    Widget widget = this.makeItem(_item, false);
                    if (widget == null) continue;
                    widgetList.add(widget);
                }
                if (widgetList.isEmpty()) {
                    return null;
                }
                return this.makeDropDownMenuButton(groups.getCaption(), widgetList);
            }
            ArrayList<Widget> widgetList = new ArrayList<Widget>();
            for (MenuItem _item : groups.getItems()) {
                Widget result2 = this.makeItem(_item, false);
                if (result2 == null) continue;
                widgetList.add(result2);
            }
            if (widgetList.isEmpty()) {
                return null;
            }
            return this.makeDropDownMenuButton(groups.getCaption(), widgetList);
        }
        if (item instanceof MenuCustom && (result = ((MenuCustom)item).build()) instanceof Widget) {
            return (Widget)result;
        }
        return null;
    }

    private Widget makeDropDownMenuButton(String caption, List<Widget> widgetList) {
        ButtonGroup buttonGroup = new ButtonGroup();
        Button dropdownButton = new Button(caption);
        dropdownButton.setDataToggle(Toggle.DROPDOWN);
        dropdownButton.setSize(ButtonSize.SMALL);
        DropDownMenu dropDownMenu = new DropDownMenu();
        for (Widget _item : widgetList) {
            dropDownMenu.add(_item);
        }
        buttonGroup.add((Widget)dropdownButton);
        buttonGroup.add((Widget)dropDownMenu);
        return buttonGroup;
    }
}

