/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.bars;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.view.bars.DocksExpandedBar;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.ouia.OuiaComponentTypeAttribute;

@RunWith(value=GwtMockitoTestRunner.class)
public class DocksExpandedBarTest {
    @Mock
    private Element elementMock;
    private DocksExpandedBar docksExpandedBar;
    private FlowPanel targetPanel;

    @Before
    public void setup() {
        DocksExpandedBar dock = new DocksExpandedBar(UberfireDockPosition.WEST);
        dock.targetPanel = this.targetPanel = (FlowPanel)Mockito.mock(FlowPanel.class);
        this.docksExpandedBar = (DocksExpandedBar)Mockito.spy((Object)dock);
        ((DocksExpandedBar)Mockito.doReturn((Object)this.elementMock).when((Object)this.docksExpandedBar)).getElement();
    }

    @Test
    public void resizeTest() {
        this.docksExpandedBar.onResize();
        ((DocksExpandedBar)Mockito.verify((Object)this.docksExpandedBar)).resizeTargetPanel();
    }

    @Test
    public void resizeWithAnInvalidWidthShouldNeverSetupSizeOfTargetPanel() {
        ((DocksExpandedBar)Mockito.doReturn((Object)0).when((Object)this.docksExpandedBar)).calculateDockHeight();
        ((DocksExpandedBar)Mockito.doReturn((Object)0).when((Object)this.docksExpandedBar)).calculateDockWidth();
        this.docksExpandedBar.onResize();
        ((FlowPanel)Mockito.verify((Object)this.targetPanel, (VerificationMode)Mockito.never())).setPixelSize(Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void resizeWithAValidWidthShouldNeverSetupSizeOfTargetPanel() {
        ((DocksExpandedBar)Mockito.doReturn((Object)10).when((Object)this.docksExpandedBar)).calculateDockHeight();
        ((DocksExpandedBar)Mockito.doReturn((Object)110).when((Object)this.docksExpandedBar)).calculateDockWidth();
        this.docksExpandedBar.onResize();
        ((FlowPanel)Mockito.verify((Object)this.targetPanel, (VerificationMode)Mockito.never())).setPixelSize(10, 110);
    }

    @Test
    public void setPanelSizeWithAnInvalidWidthShouldNeverSetupSizeOfTargetPanel() {
        this.docksExpandedBar.setPanelSize(0, -1);
        ((FlowPanel)Mockito.verify((Object)this.targetPanel, (VerificationMode)Mockito.never())).setPixelSize(Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void setPanelSizeAValidWidthShouldNeverSetupSizeOfTargetPanel() {
        this.docksExpandedBar.setPanelSize(1, 10);
        ((FlowPanel)Mockito.verify((Object)this.targetPanel)).setPixelSize(1, 10);
    }

    @Test
    public void testOuiaComponentTypeAttribute() {
        Assert.assertEquals((Object)"expanded-docks-bar", (Object)this.docksExpandedBar.ouiaComponentType().getValue());
    }

    @Test
    public void testOuiaComponentIdAttribute() {
        Assert.assertEquals((Object)"expanded-docks-bar-W", (Object)this.docksExpandedBar.ouiaComponentId().getValue());
    }

    @Test
    public void testOuiaAttributeRenderer() {
        OuiaComponentTypeAttribute componentTypeAttribute = this.docksExpandedBar.ouiaComponentType();
        this.docksExpandedBar.ouiaAttributeRenderer().accept(componentTypeAttribute);
        ((Element)Mockito.verify((Object)this.elementMock)).setAttribute(componentTypeAttribute.getName(), componentTypeAttribute.getValue());
    }
}

