/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.uberfire.client.docks.view.items.AbstractDockItem;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.mvp.ParameterizedCommand;

public class SouthDockItem
extends AbstractDockItem {
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    private final ParameterizedCommand<String> openCommand;
    private final ParameterizedCommand<String> closeCommand;
    @UiField
    Button itemButton;
    private boolean opened;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);

    SouthDockItem(UberfireDock dock, ParameterizedCommand<String> openCommand, ParameterizedCommand<String> closeCommand) {
        super(dock);
        this.openCommand = openCommand;
        this.closeCommand = closeCommand;
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.createButton();
        this.setupLocators(dock);
    }

    void createButton() {
        this.itemButton.setSize(ButtonSize.SMALL);
        this.itemButton.setType(ButtonType.LINK);
        this.configureText(this.itemButton, this.getDock().getLabel());
        this.configureIcon(this.itemButton, this.getDock().getImageIcon());
        this.itemButton.getElement().addClassName(CSS.CSS().southDockItem());
        this.itemButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!SouthDockItem.this.opened) {
                    SouthDockItem.this.open();
                    SouthDockItem.this.openCommand.execute((Object)SouthDockItem.this.getIdentifier());
                } else {
                    SouthDockItem.this.close();
                    SouthDockItem.this.closeCommand.execute((Object)SouthDockItem.this.getIdentifier());
                }
            }
        });
    }

    @Override
    public void openAndExecuteExpandCommand() {
        this.open();
        this.openCommand.execute((Object)this.getIdentifier());
    }

    @Override
    public void open() {
        this.opened = true;
        this.itemButton.setType(ButtonType.INFO);
        if (this.getDock().getImageIconFocused() != null) {
            this.itemButton.remove(0);
            this.configureImageIcon(this.itemButton, this.getDock().getImageIconFocused());
        }
    }

    @Override
    public void close() {
        this.opened = false;
        this.itemButton.setType(ButtonType.LINK);
        if (this.getDock().getImageIcon() != null) {
            this.itemButton.remove(0);
            this.configureImageIcon(this.itemButton, this.getDock().getImageIcon());
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, SouthDockItem> {
    }
}

