/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import java.util.function.Consumer;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.ouia.OuiaAttribute;
import org.uberfire.client.workbench.ouia.OuiaComponent;
import org.uberfire.client.workbench.ouia.OuiaComponentIdAttribute;
import org.uberfire.client.workbench.ouia.OuiaComponentTypeAttribute;
import org.uberfire.mvp.ParameterizedCommand;

public class DockResizeBar
extends FlowPanel
implements OuiaComponent {
    private static final String OUIA_COMPONENT_TYPE = "resize-docks-bar";
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    private Element glassElem = null;
    private boolean mouseDown;
    private double offset;
    private ParameterizedCommand<Double> resizeCommand;
    private DocksBar docksBar;

    public DockResizeBar(DocksBar docksBar) {
        this.docksBar = docksBar;
        this.sinkEvents(78);
        this.getElement().addClassName(CSS.CSS().resizableBar());
        this.setupGlassElement();
        this.setupMouseHandlers(docksBar);
        this.initOuiaComponentAttributes();
    }

    public void setup(ParameterizedCommand<Double> resizeCommand) {
        this.resizeCommand = resizeCommand;
    }

    public Consumer<OuiaAttribute> ouiaAttributeRenderer() {
        return ouiaAttribute -> this.getElement().setAttribute(ouiaAttribute.getName(), ouiaAttribute.getValue());
    }

    public OuiaComponentTypeAttribute ouiaComponentType() {
        return new OuiaComponentTypeAttribute(OUIA_COMPONENT_TYPE);
    }

    public OuiaComponentIdAttribute ouiaComponentId() {
        return new OuiaComponentIdAttribute("resize-docks-bar-" + this.docksBar.getPosition().getShortName());
    }

    private void setupMouseHandlers(final DocksBar docksBar) {
        this.addDomHandler((EventHandler)new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (DockResizeBar.this.mouseDown) {
                    DockResizeBar.this.setupMoveIcon();
                    DockResizeBar.this.resizeCommand.execute((Object)DockResizeBar.this.calculateDockSize(event, docksBar));
                    event.preventDefault();
                }
            }
        }, MouseMoveEvent.getType());
        this.addDomHandler((EventHandler)new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                DockResizeBar.this.setupMoveIcon();
            }
        }, MouseOverEvent.getType());
        this.addDomHandler((EventHandler)new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                DockResizeBar.this.setupMoveIcon();
                DockResizeBar.this.mouseDown = true;
                int width = Math.max(Window.getClientWidth(), Document.get().getScrollWidth());
                int height = Math.max(Window.getClientHeight(), Document.get().getScrollHeight());
                DockResizeBar.this.glassElem.getStyle().setHeight((double)height, Style.Unit.PX);
                DockResizeBar.this.glassElem.getStyle().setWidth((double)width, Style.Unit.PX);
                Document.get().getBody().appendChild((Node)DockResizeBar.this.glassElem);
                DockResizeBar.this.buildOffset(event);
                Event.setCapture((Element)DockResizeBar.this.getElement());
                event.preventDefault();
            }
        }, MouseDownEvent.getType());
        this.addDomHandler((EventHandler)new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                DockResizeBar.this.getElement().getStyle().setProperty("cursor", "default");
                DockResizeBar.this.mouseDown = false;
                DockResizeBar.this.glassElem.removeFromParent();
                Event.releaseCapture((Element)DockResizeBar.this.getElement());
            }
        }, MouseUpEvent.getType());
    }

    private void setupGlassElement() {
        this.glassElem = Document.get().createDivElement();
        this.glassElem.getStyle().setPosition(Style.Position.ABSOLUTE);
        this.glassElem.getStyle().setTop(0.0, Style.Unit.PX);
        this.glassElem.getStyle().setLeft(0.0, Style.Unit.PX);
        this.glassElem.getStyle().setMargin(0.0, Style.Unit.PX);
        this.glassElem.getStyle().setPadding(0.0, Style.Unit.PX);
        this.glassElem.getStyle().setBorderWidth(0.0, Style.Unit.PX);
        this.glassElem.getStyle().setProperty("background", "white");
        this.glassElem.getStyle().setProperty("backgroundColor", "red");
        this.glassElem.getStyle().setOpacity(0.0);
    }

    private void setupMoveIcon() {
        UberfireDockPosition position = this.docksBar.getPosition();
        if (position == UberfireDockPosition.SOUTH) {
            this.getElement().getStyle().setProperty("cursor", "ns-resize");
        } else {
            this.getElement().getStyle().setProperty("cursor", "ew-resize");
        }
    }

    private double calculateDockSize(MouseMoveEvent event, DocksBar docksBar) {
        UberfireDockPosition position = docksBar.getPosition();
        if (position == UberfireDockPosition.WEST) {
            return docksBar.getExpandedBarSize() + (double)(event.getClientX() - this.getAbsoluteLeft());
        }
        if (position == UberfireDockPosition.EAST) {
            return docksBar.getExpandedBarSize() + (double)(this.getAbsoluteLeft() - event.getClientX());
        }
        if (position == UberfireDockPosition.SOUTH) {
            return docksBar.getExpandedBarSize() + (double)(this.getAbsoluteTop() - event.getClientY());
        }
        return docksBar.getExpandedBarSize();
    }

    private void buildOffset(MouseDownEvent event) {
        this.offset = event.getClientX() - this.getAbsoluteLeft();
    }
}

