/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.DocksBars;
import org.uberfire.client.docks.view.bars.DocksCollapsedBar;
import org.uberfire.client.docks.view.bars.DocksExpandedBar;
import org.uberfire.client.docks.view.menu.MenuBuilder;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDocksContainer;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DocksBars_OpenDockTest {
    @Mock
    private UberfireDocksContainer uberfireDocksContainer;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private MenuBuilder menuBuilder;
    @InjectMocks
    private DocksBars docksBars;
    @Captor
    private ArgumentCaptor<PlaceRequest> placeRequestArgumentCaptor;

    @Test
    public void testOpenDockParametersArePreserved() throws Exception {
        DefaultPlaceRequest myPlace = new DefaultPlaceRequest("myPlace");
        myPlace.addParameter("my_parameter_key", "my_parameter_value");
        this.docksBars.openDock(this.getTargetDock(myPlace), this.getDocksBar());
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)this.placeRequestArgumentCaptor.capture(), (HasWidgets)Mockito.any());
        PlaceRequest placeRequest = (PlaceRequest)this.placeRequestArgumentCaptor.getValue();
        Assert.assertEquals((Object)"myPlace", (Object)placeRequest.getIdentifier());
        Assert.assertEquals((Object)"my_parameter_value", (Object)placeRequest.getParameter("my_parameter_key", ""));
    }

    private UberfireDock getTargetDock(DefaultPlaceRequest placeRequest) {
        UberfireDock targetDock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)targetDock.getPlaceRequest()).thenReturn((Object)placeRequest);
        return targetDock;
    }

    private DocksBar getDocksBar() {
        DocksBar docksBar = (DocksBar)Mockito.mock(DocksBar.class);
        Mockito.when((Object)docksBar.getCollapsedBar()).thenReturn(Mockito.mock(DocksCollapsedBar.class));
        DocksExpandedBar docksExpandedBar = (DocksExpandedBar)Mockito.mock(DocksExpandedBar.class);
        Mockito.when((Object)docksExpandedBar.targetPanel()).thenReturn(Mockito.mock(FlowPanel.class));
        Mockito.when((Object)docksBar.getExpandedBar()).thenReturn((Object)docksExpandedBar);
        Mockito.when((Object)docksBar.getExpandedBar()).thenReturn(Mockito.mock(DocksExpandedBar.class));
        return docksBar;
    }
}

