/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.user.client.Element;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.docks.view.items.AbstractDockItem;
import org.uberfire.client.docks.view.items.SideDockItem;
import org.uberfire.client.docks.view.items.SingleSideDockItem;
import org.uberfire.client.docks.view.items.SouthDockItem;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.ouia.OuiaComponentTypeAttribute;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractDockItemOuiaTest {
    @Mock
    private Element elementMock;
    @Mock
    private UberfireDock dockMock;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.dockMock.getIdentifier()).thenReturn((Object)"xyz");
    }

    @Test
    public void testSouthDockItem() {
        Mockito.when((Object)this.dockMock.getDockPosition()).thenReturn((Object)UberfireDockPosition.SOUTH);
        this.assertOuiaCompliance((AbstractDockItem)new SouthDockItem(this.dockMock, (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class), (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class)));
    }

    @Test
    public void testSideDockItems() {
        Mockito.when((Object)this.dockMock.getDockPosition()).thenReturn((Object)UberfireDockPosition.WEST);
        this.assertOuiaCompliance((AbstractDockItem)new SideDockItem(this.dockMock, (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class), (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class)));
        this.assertOuiaCompliance((AbstractDockItem)new SingleSideDockItem(this.dockMock, (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class)));
    }

    private void assertOuiaCompliance(AbstractDockItem dockItem) {
        dockItem = (AbstractDockItem)Mockito.spy((Object)dockItem);
        ((AbstractDockItem)Mockito.doReturn((Object)this.elementMock).when((Object)dockItem)).getElement();
        OuiaComponentTypeAttribute componentTypeAttribute = dockItem.ouiaComponentType();
        Assert.assertEquals((Object)"docks-item", (Object)componentTypeAttribute.getValue());
        Assert.assertEquals((Object)"docks-item-xyz", (Object)dockItem.ouiaComponentId().getValue());
        dockItem.ouiaAttributeRenderer().accept(componentTypeAttribute);
        ((Element)Mockito.verify((Object)this.elementMock)).setAttribute(componentTypeAttribute.getName(), componentTypeAttribute.getValue());
        Mockito.reset((Object[])new Element[]{this.elementMock});
    }
}

