/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.UberfireDocksImpl;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.DocksBars;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockContainerReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.toolbar.IconType;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberfireDocksImplTest {
    private final String SOME_PERSPECTIVE = "SomePerspective";
    private final String ANOTHER_PERSPECTIVE = "AnotherPerspective";
    @Mock
    private DocksBars docksBars;
    @Mock
    private DockLayoutPanel dockLayoutPanel;
    @Mock
    EventSourceMock<UberfireDockReadyEvent> dockReadyEvent;
    private UberfireDocksImpl uberfireDocks;
    private Command resizeCommand;
    private UberfireDock dock0 = new UberfireDock(UberfireDockPosition.SOUTH, IconType.CHEVRON_RIGHT.name(), (PlaceRequest)new DefaultPlaceRequest("welcome"), "SomePerspective").withLabel("albel");
    private UberfireDock dock1 = new UberfireDock(UberfireDockPosition.SOUTH, IconType.AMBULANCE.name(), (PlaceRequest)new DefaultPlaceRequest("another"), "SomePerspective").withLabel("Another").withSize(200.0);
    private UberfireDock dock2 = new UberfireDock(UberfireDockPosition.EAST, IconType.ADJUST.name(), (PlaceRequest)new DefaultPlaceRequest("test"), "SomePerspective");
    private UberfireDock dock3 = new UberfireDock(UberfireDockPosition.EAST, IconType.BELL_ALT.name(), (PlaceRequest)new DefaultPlaceRequest("welcome"), "AnotherPerspective");
    private UberfireDock dock4 = new UberfireDock(UberfireDockPosition.WEST, IconType.FACETIME_VIDEO.name(), (PlaceRequest)new DefaultPlaceRequest("welcome"), "AnotherPerspective").withLabel("Welcome").withSize(200.0);

    @Before
    public void setup() {
        this.uberfireDocks = new UberfireDocksImpl(this.docksBars, this.dockReadyEvent);
        this.resizeCommand = () -> {};
    }

    @Test
    public void setupDocks() {
        this.uberfireDocks.setup(new UberfireDockContainerReadyEvent());
        ((DocksBars)Mockito.verify((Object)this.docksBars)).setup();
    }

    @Test
    public void add() {
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1, this.dock2, this.dock3, this.dock4});
        List docksSomePerspective = (List)this.uberfireDocks.docksPerPerspective.get("SomePerspective");
        List docksAnotherPerspective = (List)this.uberfireDocks.docksPerPerspective.get("AnotherPerspective");
        Assert.assertEquals((long)3L, (long)docksSomePerspective.size());
        Assert.assertEquals((long)2L, (long)docksAnotherPerspective.size());
    }

    @Test
    public void perspectiveChangeEvent() {
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.perspectiveChangeEvent(new PerspectiveChange(null, null, null, "SomePerspective"));
        Assert.assertEquals((Object)"SomePerspective", (Object)this.uberfireDocks.currentPerspective);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.times((int)1))).clearAndHideAllDocks();
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.times((int)1))).addDock(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.times((int)1))).addDock(this.dock1);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.times((int)docksBars.size()))).show((DocksBar)ArgumentMatchers.any(DocksBar.class));
    }

    @Test
    public void remove() {
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        this.uberfireDocks.currentPerspective = "SomePerspective";
        this.uberfireDocks.remove(new UberfireDock[]{this.dock0});
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.times((int)2))).isReady((UberfireDockPosition)ArgumentMatchers.any());
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.times((int)1))).clearAndCollapseDocks((UberfireDockPosition)ArgumentMatchers.any());
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.never())).addDock(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.never())).addDock(this.dock1);
    }

    @Test
    public void disableDock() {
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.currentPerspective = "SomePerspective";
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.hide(UberfireDockPosition.WEST, "SomePerspective");
        ((DocksBars)Mockito.verify((Object)this.docksBars)).clearAndHide(UberfireDockPosition.WEST);
    }

    @Test
    public void enableDock() {
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.currentPerspective = "SomePerspective";
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.hide(UberfireDockPosition.WEST, "SomePerspective");
        this.uberfireDocks.show(UberfireDockPosition.WEST, "SomePerspective");
        ((DocksBars)Mockito.verify((Object)this.docksBars)).show(UberfireDockPosition.WEST);
    }

    @Test
    public void closeDockTest() {
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.currentPerspective = "SomePerspective";
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.open(this.dock0);
        this.uberfireDocks.close(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars)).close(this.dock0);
    }

    @Test
    public void toggleDockTest() {
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.currentPerspective = "SomePerspective";
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)true);
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.toggle(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars)).toggle(this.dock0);
    }

    @Test
    public void openCloseDelayedOperationsTest() {
        Mockito.when((Object)this.docksBars.isReady((UberfireDockPosition)ArgumentMatchers.any())).thenReturn((Object)false);
        this.uberfireDocks.add(new UberfireDock[]{this.dock0, this.dock1});
        this.uberfireDocks.currentPerspective = "SomePerspective";
        List<DocksBar> docksBars = this.generateDocksBars();
        Mockito.when((Object)this.docksBars.getDocksBars()).thenReturn(docksBars);
        this.uberfireDocks.open(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.never())).open(this.dock0);
        this.uberfireDocks.close(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.never())).close(this.dock0);
        Assert.assertEquals((long)2L, (long)((List)this.uberfireDocks.delayedCommandsPerPerspective.get("SomePerspective")).size());
        PerspectiveChange event = (PerspectiveChange)Mockito.mock(PerspectiveChange.class);
        Mockito.when((Object)event.getIdentifier()).thenReturn((Object)"Another");
        this.uberfireDocks.perspectiveChangeEvent(event);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.never())).open(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars, (VerificationMode)Mockito.never())).close(this.dock0);
        Mockito.when((Object)event.getIdentifier()).thenReturn((Object)"SomePerspective");
        this.uberfireDocks.perspectiveChangeEvent(event);
        ((DocksBars)Mockito.verify((Object)this.docksBars)).open(this.dock0);
        ((DocksBars)Mockito.verify((Object)this.docksBars)).close(this.dock0);
        Assert.assertNull(this.uberfireDocks.delayedCommandsPerPerspective.get("SomePerspective"));
    }

    private List<DocksBar> generateDocksBars() {
        ArrayList<DocksBar> docksBar = new ArrayList<DocksBar>();
        docksBar.add(this.createDocksBar(UberfireDockPosition.WEST));
        docksBar.add(this.createDocksBar(UberfireDockPosition.EAST));
        docksBar.add(this.createDocksBar(UberfireDockPosition.SOUTH));
        return docksBar;
    }

    private DocksBar createDocksBar(UberfireDockPosition west) {
        return new DocksBar(west){

            protected void setupChildBars(UberfireDockPosition position) {
            }

            public boolean equals(Object obj) {
                DocksBar obj1 = (DocksBar)obj;
                return this.getPosition().equals((Object)obj1.getPosition());
            }
        };
    }
}

