/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.bars;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.uberfire.client.docks.view.items.AbstractDockItem;
import org.uberfire.client.docks.view.items.SingleSideDockItem;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.util.CSSLocatorsUtils;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.ouia.OuiaAttribute;
import org.uberfire.client.workbench.ouia.OuiaComponent;
import org.uberfire.client.workbench.ouia.OuiaComponentIdAttribute;
import org.uberfire.client.workbench.ouia.OuiaComponentTypeAttribute;
import org.uberfire.mvp.ParameterizedCommand;

public class DocksCollapsedBar
extends Composite
implements OuiaComponent {
    private static final String OUIA_COMPONENT_TYPE = "collapsed-docks-bar";
    @UiField
    FlowPanel docksBarPanel;
    private UberfireDockPosition position;
    private WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    private AbstractDockItem firstDockItem;
    private SingleSideDockItem singleSideDockItem;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private List<AbstractDockItem> docksItems = new ArrayList<AbstractDockItem>();

    public DocksCollapsedBar(UberfireDockPosition position) {
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.position = position;
        this.setCSS(position);
        this.setupLocators(position);
    }

    private void setCSS(UberfireDockPosition position) {
        if (position == UberfireDockPosition.SOUTH) {
            this.docksBarPanel.addStyleName(this.CSS.CSS().gradientTopBottom());
        } else {
            this.docksBarPanel.addStyleName(this.CSS.CSS().gradientBottomTop());
        }
    }

    private void setupLocators(UberfireDockPosition position) {
        this.initOuiaComponentAttributes();
        this.docksBarPanel.addStyleName(CSSLocatorsUtils.buildLocator((String[])new String[]{OUIA_COMPONENT_TYPE, position.getShortName()}));
    }

    public void addDock(UberfireDock dock, ParameterizedCommand<String> openCommand, ParameterizedCommand<String> closeCommand) {
        AbstractDockItem dockItem = AbstractDockItem.create(dock, openCommand, closeCommand);
        if (dock.getDockPosition().allowSingleDockItem()) {
            this.handleSingleDockItem(dockItem, dock, openCommand);
        }
        this.docksBarPanel.add((Widget)dockItem);
        this.docksItems.add(dockItem);
    }

    private void handleSingleDockItem(AbstractDockItem dockItem, UberfireDock dock, ParameterizedCommand<String> openCommand) {
        if (this.docksItems.isEmpty()) {
            this.createSingleDockItem(dockItem, dock, openCommand);
        } else if (this.singleDockMode()) {
            this.clearSingleDockItem();
        }
    }

    public boolean singleDockMode() {
        return this.position.allowSingleDockItem() && this.docksItems.size() == 1;
    }

    private void createSingleDockItem(AbstractDockItem dockItem, UberfireDock dock, ParameterizedCommand<String> openCommand) {
        this.firstDockItem = dockItem;
        this.firstDockItem.addStyleName(this.CSS.CSS().hideElement());
        this.singleSideDockItem = new SingleSideDockItem(dock, openCommand);
        this.docksBarPanel.add((Widget)this.singleSideDockItem);
    }

    private void clearSingleDockItem() {
        this.firstDockItem.removeStyleName(this.CSS.CSS().hideElement());
        this.docksBarPanel.remove((Widget)this.singleSideDockItem);
    }

    public void clear() {
        this.docksBarPanel.clear();
        this.docksItems = new ArrayList<AbstractDockItem>();
    }

    public void setDockClosed(UberfireDock dockOpen) {
        for (AbstractDockItem docksItem : this.docksItems) {
            if (docksItem.getDock().equals((Object)dockOpen)) {
                docksItem.open();
                continue;
            }
            docksItem.close();
        }
    }

    public void closeAllDocks() {
        for (AbstractDockItem docksItem : this.docksItems) {
            docksItem.close();
        }
    }

    public UberfireDockPosition getPosition() {
        return this.position;
    }

    public List<AbstractDockItem> getDocksItems() {
        return this.docksItems;
    }

    public void expand(UberfireDock targetDock) {
        for (AbstractDockItem abstractDockItem : this.getDocksItems()) {
            UberfireDock candidate = abstractDockItem.getDock();
            if (!candidate.getPlaceRequest().equals(targetDock.getPlaceRequest())) continue;
            abstractDockItem.openAndExecuteExpandCommand();
        }
    }

    public Consumer<OuiaAttribute> ouiaAttributeRenderer() {
        return ouiaAttribute -> this.getElement().setAttribute(ouiaAttribute.getName(), ouiaAttribute.getValue());
    }

    public OuiaComponentTypeAttribute ouiaComponentType() {
        return new OuiaComponentTypeAttribute(OUIA_COMPONENT_TYPE);
    }

    public OuiaComponentIdAttribute ouiaComponentId() {
        return new OuiaComponentIdAttribute("collapsed-docks-bar-" + this.position.getShortName());
    }

    static interface ViewBinder
    extends UiBinder<Widget, DocksCollapsedBar> {
    }
}

