/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view;

import com.google.gwt.user.client.Element;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.docks.view.DockResizeBar;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.ouia.OuiaComponentTypeAttribute;

@RunWith(value=GwtMockitoTestRunner.class)
public class DockResizeBarTest {
    private static final String POSITION_SHORT_NAME = "W";
    @Mock
    private Element elementMock;
    @Mock
    private UberfireDockPosition dockPositionMock;
    @Mock
    private DocksBar docksBarMock;
    private DockResizeBar dockResizeBar;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.docksBarMock.getPosition()).thenReturn((Object)this.dockPositionMock);
        Mockito.when((Object)this.dockPositionMock.getShortName()).thenReturn((Object)POSITION_SHORT_NAME);
        this.dockResizeBar = (DockResizeBar)Mockito.spy((Object)new DockResizeBar(this.docksBarMock));
        Mockito.when((Object)this.dockResizeBar.getElement()).thenReturn((Object)this.elementMock);
    }

    @Test
    public void testOuiaComponentTypeAttribute() {
        Assert.assertEquals((Object)"resize-docks-bar", (Object)this.dockResizeBar.ouiaComponentType().getValue());
    }

    @Test
    public void testOuiaComponentIdAttribute() {
        Assert.assertEquals((Object)"resize-docks-bar-W", (Object)this.dockResizeBar.ouiaComponentId().getValue());
    }

    @Test
    public void testOuiaAttributeRenderer() {
        OuiaComponentTypeAttribute componentTypeAttribute = this.dockResizeBar.ouiaComponentType();
        this.dockResizeBar.ouiaAttributeRenderer().accept(componentTypeAttribute);
        ((Element)Mockito.verify((Object)this.elementMock)).setAttribute(componentTypeAttribute.getName(), componentTypeAttribute.getValue());
    }
}

